package zio.aws.rdsdata.model
import scala.jdk.CollectionConverters.*
sealed trait LongReturnType {
  def unwrap: software.amazon.awssdk.services.rdsdata.model.LongReturnType
}
object LongReturnType {
  def wrap(
      value: software.amazon.awssdk.services.rdsdata.model.LongReturnType
  ): zio.aws.rdsdata.model.LongReturnType = value match {
    case software.amazon.awssdk.services.rdsdata.model.LongReturnType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rdsdata.model.LongReturnType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.rdsdata.model.LongReturnType.LONG =>
      val r = LONG
      r
  }
  case object unknownToSdkVersion extends zio.aws.rdsdata.model.LongReturnType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.LongReturnType =
      software.amazon.awssdk.services.rdsdata.model.LongReturnType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING extends zio.aws.rdsdata.model.LongReturnType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.LongReturnType =
      software.amazon.awssdk.services.rdsdata.model.LongReturnType.STRING
  }
  case object LONG extends zio.aws.rdsdata.model.LongReturnType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.LongReturnType =
      software.amazon.awssdk.services.rdsdata.model.LongReturnType.LONG
  }
}
