package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Id, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CommitTransactionRequest(
    resourceArn: Arn,
    secretArn: Arn,
    transactionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest = {
    import CommitTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .transactionId(Id.unwrap(transactionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.CommitTransactionRequest.ReadOnly =
    zio.aws.rdsdata.model.CommitTransactionRequest.wrap(buildAwsValue())
}
object CommitTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.CommitTransactionRequest =
      zio.aws.rdsdata.model
        .CommitTransactionRequest(resourceArn, secretArn, transactionId)
    def resourceArn: Arn
    def secretArn: Arn
    def transactionId: Id
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getTransactionId: ZIO[Any, Nothing, Id] = ZIO.succeed(transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest
  ) extends zio.aws.rdsdata.model.CommitTransactionRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val transactionId: Id =
      zio.aws.rdsdata.model.primitives.Id(impl.transactionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest
  ): zio.aws.rdsdata.model.CommitTransactionRequest.ReadOnly = new Wrapper(impl)
}
