package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{BoxedLong, BoxedDouble, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ArrayValue(
    arrayValues: Optional[Iterable[zio.aws.rdsdata.model.ArrayValue]] =
      Optional.Absent,
    booleanValues: Optional[Iterable[BoxedBoolean]] = Optional.Absent,
    doubleValues: Optional[Iterable[BoxedDouble]] = Optional.Absent,
    longValues: Optional[Iterable[BoxedLong]] = Optional.Absent,
    stringValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ArrayValue = {
    import ArrayValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ArrayValue
      .builder()
      .optionallyWith(
        arrayValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.arrayValues)
      .optionallyWith(
        booleanValues.map(value =>
          value.map { item =>
            item: java.lang.Boolean
          }.asJavaCollection
        )
      )(_.booleanValues)
      .optionallyWith(
        doubleValues.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.doubleValues)
      .optionallyWith(
        longValues.map(value =>
          value.map { item =>
            item: java.lang.Long
          }.asJavaCollection
        )
      )(_.longValues)
      .optionallyWith(
        stringValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stringValues)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ArrayValue.ReadOnly =
    zio.aws.rdsdata.model.ArrayValue.wrap(buildAwsValue())
}
object ArrayValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ArrayValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ArrayValue =
      zio.aws.rdsdata.model.ArrayValue(
        arrayValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        booleanValues.map(value => value),
        doubleValues.map(value => value),
        longValues.map(value => value),
        stringValues.map(value => value)
      )
    def arrayValues: Optional[List[zio.aws.rdsdata.model.ArrayValue.ReadOnly]]
    def booleanValues: Optional[List[BoxedBoolean]]
    def doubleValues: Optional[List[BoxedDouble]]
    def longValues: Optional[List[BoxedLong]]
    def stringValues: Optional[List[String]]
    def getArrayValues
        : ZIO[Any, AwsError, List[zio.aws.rdsdata.model.ArrayValue.ReadOnly]] =
      AwsError.unwrapOptionField("arrayValues", arrayValues)
    def getBooleanValues: ZIO[Any, AwsError, List[BoxedBoolean]] =
      AwsError.unwrapOptionField("booleanValues", booleanValues)
    def getDoubleValues: ZIO[Any, AwsError, List[BoxedDouble]] =
      AwsError.unwrapOptionField("doubleValues", doubleValues)
    def getLongValues: ZIO[Any, AwsError, List[BoxedLong]] =
      AwsError.unwrapOptionField("longValues", longValues)
    def getStringValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stringValues", stringValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ArrayValue
  ) extends zio.aws.rdsdata.model.ArrayValue.ReadOnly {
    override val arrayValues
        : Optional[List[zio.aws.rdsdata.model.ArrayValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arrayValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rdsdata.model.ArrayValue.wrap(item)
          }.toList
        )
    override val booleanValues: Optional[List[BoxedBoolean]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.booleanValues())
        .map(value =>
          value.asScala.map { item =>
            item: BoxedBoolean
          }.toList
        )
    override val doubleValues: Optional[List[BoxedDouble]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.doubleValues())
        .map(value =>
          value.asScala.map { item =>
            item: BoxedDouble
          }.toList
        )
    override val longValues: Optional[List[BoxedLong]] = zio.aws.core.internal
      .optionalFromNullable(impl.longValues())
      .map(value =>
        value.asScala.map { item =>
          item: BoxedLong
        }.toList
      )
    override val stringValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ArrayValue
  ): zio.aws.rdsdata.model.ArrayValue.ReadOnly = new Wrapper(impl)
}
