package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{
  BoxedLong,
  BoxedDouble,
  BoxedBoolean,
  Blob
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Field(
    arrayValue: Optional[zio.aws.rdsdata.model.ArrayValue] = Optional.Absent,
    blobValue: Optional[Blob] = Optional.Absent,
    booleanValue: Optional[BoxedBoolean] = Optional.Absent,
    doubleValue: Optional[BoxedDouble] = Optional.Absent,
    isNull: Optional[BoxedBoolean] = Optional.Absent,
    longValue: Optional[BoxedLong] = Optional.Absent,
    stringValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rdsdata.model.Field = {
    import Field.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.Field
      .builder()
      .optionallyWith(arrayValue.map(value => value.buildAwsValue()))(
        _.arrayValue
      )
      .optionallyWith(
        blobValue.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.blobValue)
      .optionallyWith(booleanValue.map(value => value: java.lang.Boolean))(
        _.booleanValue
      )
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(isNull.map(value => value: java.lang.Boolean))(_.isNull)
      .optionallyWith(longValue.map(value => value: java.lang.Long))(
        _.longValue
      )
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.Field.ReadOnly =
    zio.aws.rdsdata.model.Field.wrap(buildAwsValue())
}
object Field {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rdsdata.model.Field] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.Field = zio.aws.rdsdata.model.Field(
      arrayValue.map(value => value.asEditable),
      blobValue.map(value => value),
      booleanValue.map(value => value),
      doubleValue.map(value => value),
      isNull.map(value => value),
      longValue.map(value => value),
      stringValue.map(value => value)
    )
    def arrayValue: Optional[zio.aws.rdsdata.model.ArrayValue.ReadOnly]
    def blobValue: Optional[Blob]
    def booleanValue: Optional[BoxedBoolean]
    def doubleValue: Optional[BoxedDouble]
    def isNull: Optional[BoxedBoolean]
    def longValue: Optional[BoxedLong]
    def stringValue: Optional[String]
    def getArrayValue
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.ArrayValue.ReadOnly] =
      AwsError.unwrapOptionField("arrayValue", arrayValue)
    def getBlobValue: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blobValue", blobValue)
    def getBooleanValue: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getDoubleValue: ZIO[Any, AwsError, BoxedDouble] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getIsNull: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("isNull", isNull)
    def getLongValue: ZIO[Any, AwsError, BoxedLong] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.Field
  ) extends zio.aws.rdsdata.model.Field.ReadOnly {
    override val arrayValue
        : Optional[zio.aws.rdsdata.model.ArrayValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arrayValue())
        .map(value => zio.aws.rdsdata.model.ArrayValue.wrap(value))
    override val blobValue: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.blobValue())
      .map(value =>
        zio.aws.rdsdata.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val booleanValue: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.booleanValue())
      .map(value => value: BoxedBoolean)
    override val doubleValue: Optional[BoxedDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.doubleValue())
      .map(value => value: BoxedDouble)
    override val isNull: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isNull())
      .map(value => value: BoxedBoolean)
    override val longValue: Optional[BoxedLong] = zio.aws.core.internal
      .optionalFromNullable(impl.longValue())
      .map(value => value: BoxedLong)
    override val stringValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.Field
  ): zio.aws.rdsdata.model.Field.ReadOnly = new Wrapper(impl)
}
