package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Id, SqlStatement, Arn, DbName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementRequest(
    continueAfterTimeout: Optional[Boolean] = Optional.Absent,
    database: Optional[DbName] = Optional.Absent,
    includeResultMetadata: Optional[Boolean] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.rdsdata.model.SqlParameter]] =
      Optional.Absent,
    resourceArn: Arn,
    resultSetOptions: Optional[zio.aws.rdsdata.model.ResultSetOptions] =
      Optional.Absent,
    schema: Optional[DbName] = Optional.Absent,
    secretArn: Arn,
    sql: SqlStatement,
    transactionId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest = {
    import ExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
      .builder()
      .optionallyWith(
        continueAfterTimeout.map(value => value: java.lang.Boolean)
      )(_.continueAfterTimeout)
      .optionallyWith(
        database.map(value => DbName.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        includeResultMetadata.map(value => value: java.lang.Boolean)
      )(_.includeResultMetadata)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(resultSetOptions.map(value => value.buildAwsValue()))(
        _.resultSetOptions
      )
      .optionallyWith(
        schema.map(value => DbName.unwrap(value): java.lang.String)
      )(_.schema)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .sql(SqlStatement.unwrap(sql): java.lang.String)
      .optionallyWith(
        transactionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly =
    zio.aws.rdsdata.model.ExecuteStatementRequest.wrap(buildAwsValue())
}
object ExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ExecuteStatementRequest =
      zio.aws.rdsdata.model.ExecuteStatementRequest(
        continueAfterTimeout.map(value => value),
        database.map(value => value),
        includeResultMetadata.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceArn,
        resultSetOptions.map(value => value.asEditable),
        schema.map(value => value),
        secretArn,
        sql,
        transactionId.map(value => value)
      )
    def continueAfterTimeout: Optional[Boolean]
    def database: Optional[DbName]
    def includeResultMetadata: Optional[Boolean]
    def parameters: Optional[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]]
    def resourceArn: Arn
    def resultSetOptions
        : Optional[zio.aws.rdsdata.model.ResultSetOptions.ReadOnly]
    def schema: Optional[DbName]
    def secretArn: Arn
    def sql: SqlStatement
    def transactionId: Optional[Id]
    def getContinueAfterTimeout: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("continueAfterTimeout", continueAfterTimeout)
    def getDatabase: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("database", database)
    def getIncludeResultMetadata: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeResultMetadata", includeResultMetadata)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.rdsdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getResultSetOptions
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.ResultSetOptions.ReadOnly] =
      AwsError.unwrapOptionField("resultSetOptions", resultSetOptions)
    def getSchema: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("schema", schema)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getSql: ZIO[Any, Nothing, SqlStatement] = ZIO.succeed(sql)
    def getTransactionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ) extends zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly {
    override val continueAfterTimeout: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.continueAfterTimeout())
      .map(value => value: Boolean)
    override val database: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val includeResultMetadata: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeResultMetadata())
        .map(value => value: Boolean)
    override val parameters
        : Optional[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rdsdata.model.SqlParameter.wrap(item)
          }.toList
        )
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val resultSetOptions
        : Optional[zio.aws.rdsdata.model.ResultSetOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultSetOptions())
        .map(value => zio.aws.rdsdata.model.ResultSetOptions.wrap(value))
    override val schema: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val sql: SqlStatement =
      zio.aws.rdsdata.model.primitives.SqlStatement(impl.sql())
    override val transactionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => zio.aws.rdsdata.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ): zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly = new Wrapper(impl)
}
