package zio.aws.rdsdata
import zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.rdsdata.{
  RdsDataAsyncClientBuilder,
  RdsDataAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.rdsdata.model.{
  ExecuteStatementRequest,
  BeginTransactionRequest,
  RollbackTransactionRequest,
  CommitTransactionRequest,
  BatchExecuteStatementRequest
}
import software.amazon.awssdk.services.rdsdata.model.{
  ExecuteStatementResponse,
  BeginTransactionResponse,
  CommitTransactionResponse,
  BatchExecuteStatementResponse,
  RollbackTransactionResponse
}
import scala.jdk.CollectionConverters.*
trait RdsData extends AspectSupport[RdsData] {
  val api: RdsDataAsyncClient
  def commitTransaction(
      request: CommitTransactionRequest
  ): IO[AwsError, zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly]
  def rollbackTransaction(
      request: RollbackTransactionRequest
  ): IO[AwsError, zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly]
  def batchExecuteStatement(
      request: BatchExecuteStatementRequest
  ): IO[AwsError, zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly]
  def executeStatement(request: ExecuteStatementRequest): IO[AwsError, ReadOnly]
  def beginTransaction(
      request: BeginTransactionRequest
  ): IO[AwsError, zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly]
}
object RdsData {
  val live: ZLayer[AwsConfig, java.lang.Throwable, RdsData] = customized(
    identity
  )
  def customized(
      customization: RdsDataAsyncClientBuilder => RdsDataAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, RdsData] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RdsDataAsyncClientBuilder => RdsDataAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, RdsData] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RdsDataAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[RdsDataAsyncClient, RdsDataAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[RdsDataAsyncClient, RdsDataAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new RdsDataImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class RdsDataImpl[R](
      override val api: RdsDataAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends RdsData
      with AwsServiceBase[R] {
    override val serviceName: String = "RdsData"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RdsDataImpl[R1] = new RdsDataImpl(api, newAspect, r)
    def commitTransaction(
        request: CommitTransactionRequest
    ): IO[AwsError, zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest,
        CommitTransactionResponse
      ]("commitTransaction", api.commitTransaction)(request.buildAwsValue())
        .map(zio.aws.rdsdata.model.CommitTransactionResponse.wrap)
        .provideEnvironment(r)
    def rollbackTransaction(request: RollbackTransactionRequest): IO[
      AwsError,
      zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest,
      RollbackTransactionResponse
    ]("rollbackTransaction", api.rollbackTransaction)(request.buildAwsValue())
      .map(zio.aws.rdsdata.model.RollbackTransactionResponse.wrap)
      .provideEnvironment(r)
    def batchExecuteStatement(request: BatchExecuteStatementRequest): IO[
      AwsError,
      zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest,
      BatchExecuteStatementResponse
    ]("batchExecuteStatement", api.batchExecuteStatement)(
      request.buildAwsValue()
    ).map(zio.aws.rdsdata.model.BatchExecuteStatementResponse.wrap)
      .provideEnvironment(r)
    def executeStatement(
        request: ExecuteStatementRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest,
      ExecuteStatementResponse
    ]("executeStatement", api.executeStatement)(request.buildAwsValue())
      .map(zio.aws.rdsdata.model.ExecuteStatementResponse.wrap)
      .provideEnvironment(r)
    def beginTransaction(
        request: BeginTransactionRequest
    ): IO[AwsError, zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest,
        BeginTransactionResponse
      ]("beginTransaction", api.beginTransaction)(request.buildAwsValue())
        .map(zio.aws.rdsdata.model.BeginTransactionResponse.wrap)
        .provideEnvironment(r)
  }
  def commitTransaction(request: CommitTransactionRequest): ZIO[
    zio.aws.rdsdata.RdsData,
    AwsError,
    zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.commitTransaction(request))
  def rollbackTransaction(request: RollbackTransactionRequest): ZIO[
    zio.aws.rdsdata.RdsData,
    AwsError,
    zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rollbackTransaction(request))
  def batchExecuteStatement(request: BatchExecuteStatementRequest): ZIO[
    zio.aws.rdsdata.RdsData,
    AwsError,
    zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchExecuteStatement(request))
  def executeStatement(
      request: ExecuteStatementRequest
  ): ZIO[zio.aws.rdsdata.RdsData, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.executeStatement(request))
  def beginTransaction(request: BeginTransactionRequest): ZIO[
    zio.aws.rdsdata.RdsData,
    AwsError,
    zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.beginTransaction(request))
}
