package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.RecordsUpdated
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementResponse(
    columnMetadata: Option[Iterable[zio.aws.rdsdata.model.ColumnMetadata]] =
      None,
    generatedFields: Option[Iterable[zio.aws.rdsdata.model.Field]] = None,
    numberOfRecordsUpdated: Option[RecordsUpdated] = None,
    records: Option[Iterable[Iterable[zio.aws.rdsdata.model.Field]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse = {
    import ExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
      .builder()
      .optionallyWith(
        columnMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnMetadata)
      .optionallyWith(
        generatedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatedFields)
      .optionallyWith(
        numberOfRecordsUpdated.map(value =>
          RecordsUpdated.unwrap(value): java.lang.Long
        )
      )(_.numberOfRecordsUpdated)
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.records)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly =
    zio.aws.rdsdata.model.ExecuteStatementResponse.wrap(buildAwsValue())
}
object ExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ExecuteStatementResponse =
      zio.aws.rdsdata.model.ExecuteStatementResponse(
        columnMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        generatedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        numberOfRecordsUpdated.map(value => value),
        records.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        )
      )
    def columnMetadata
        : Option[List[zio.aws.rdsdata.model.ColumnMetadata.ReadOnly]]
    def generatedFields: Option[List[zio.aws.rdsdata.model.Field.ReadOnly]]
    def numberOfRecordsUpdated: Option[RecordsUpdated]
    def records: Option[List[List[zio.aws.rdsdata.model.Field.ReadOnly]]]
    def getColumnMetadata: ZIO[Any, AwsError, List[
      zio.aws.rdsdata.model.ColumnMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("columnMetadata", columnMetadata)
    def getGeneratedFields
        : ZIO[Any, AwsError, List[zio.aws.rdsdata.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("generatedFields", generatedFields)
    def getNumberOfRecordsUpdated: ZIO[Any, AwsError, RecordsUpdated] = AwsError
      .unwrapOptionField("numberOfRecordsUpdated", numberOfRecordsUpdated)
    def getRecords
        : ZIO[Any, AwsError, List[List[zio.aws.rdsdata.model.Field.ReadOnly]]] =
      AwsError.unwrapOptionField("records", records)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
  ) extends zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly {
    override val columnMetadata
        : Option[List[zio.aws.rdsdata.model.ColumnMetadata.ReadOnly]] = scala
      .Option(impl.columnMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rdsdata.model.ColumnMetadata.wrap(item)
        }.toList
      )
    override val generatedFields
        : Option[List[zio.aws.rdsdata.model.Field.ReadOnly]] = scala
      .Option(impl.generatedFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rdsdata.model.Field.wrap(item)
        }.toList
      )
    override val numberOfRecordsUpdated: Option[RecordsUpdated] = scala
      .Option(impl.numberOfRecordsUpdated())
      .map(value => zio.aws.rdsdata.model.primitives.RecordsUpdated(value))
    override val records
        : Option[List[List[zio.aws.rdsdata.model.Field.ReadOnly]]] = scala
      .Option(impl.records())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            zio.aws.rdsdata.model.Field.wrap(item)
          }.toList
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
  ): zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly = new Wrapper(impl)
}
