package zio.aws.rdsdata.model
import scala.jdk.CollectionConverters.*
sealed trait TypeHint {
  def unwrap: software.amazon.awssdk.services.rdsdata.model.TypeHint
}
object TypeHint {
  def wrap(
      value: software.amazon.awssdk.services.rdsdata.model.TypeHint
  ): zio.aws.rdsdata.model.TypeHint = value match {
    case software.amazon.awssdk.services.rdsdata.model.TypeHint.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rdsdata.model.TypeHint.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.rdsdata.model.TypeHint.UUID =>
      val r = UUID
      r
    case software.amazon.awssdk.services.rdsdata.model.TypeHint.TIMESTAMP =>
      val r = TIMESTAMP
      r
    case software.amazon.awssdk.services.rdsdata.model.TypeHint.DATE =>
      val r = DATE
      r
    case software.amazon.awssdk.services.rdsdata.model.TypeHint.TIME =>
      val r = TIME
      r
    case software.amazon.awssdk.services.rdsdata.model.TypeHint.DECIMAL =>
      val r = DECIMAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.rdsdata.model.TypeHint {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.TypeHint =
      software.amazon.awssdk.services.rdsdata.model.TypeHint.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.rdsdata.model.TypeHint {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.TypeHint =
      software.amazon.awssdk.services.rdsdata.model.TypeHint.JSON
  }
  case object UUID extends zio.aws.rdsdata.model.TypeHint {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.TypeHint =
      software.amazon.awssdk.services.rdsdata.model.TypeHint.UUID
  }
  case object TIMESTAMP extends zio.aws.rdsdata.model.TypeHint {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.TypeHint =
      software.amazon.awssdk.services.rdsdata.model.TypeHint.TIMESTAMP
  }
  case object DATE extends zio.aws.rdsdata.model.TypeHint {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.TypeHint =
      software.amazon.awssdk.services.rdsdata.model.TypeHint.DATE
  }
  case object TIME extends zio.aws.rdsdata.model.TypeHint {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.TypeHint =
      software.amazon.awssdk.services.rdsdata.model.TypeHint.TIME
  }
  case object DECIMAL extends zio.aws.rdsdata.model.TypeHint {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.TypeHint =
      software.amazon.awssdk.services.rdsdata.model.TypeHint.DECIMAL
  }
}
