package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.ParameterName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SqlParameter(
    name: Option[ParameterName] = None,
    typeHint: Option[zio.aws.rdsdata.model.TypeHint] = None,
    value: Option[zio.aws.rdsdata.model.Field] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.SqlParameter = {
    import SqlParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.SqlParameter
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(typeHint.map(value => value.unwrap))(_.typeHint)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.SqlParameter.ReadOnly =
    zio.aws.rdsdata.model.SqlParameter.wrap(buildAwsValue())
}
object SqlParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.SqlParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.SqlParameter =
      zio.aws.rdsdata.model.SqlParameter(
        name.map(value => value),
        typeHint.map(value => value),
        value.map(value => value.asEditable)
      )
    def name: Option[ParameterName]
    def typeHint: Option[zio.aws.rdsdata.model.TypeHint]
    def value: Option[zio.aws.rdsdata.model.Field.ReadOnly]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getTypeHint: ZIO[Any, AwsError, zio.aws.rdsdata.model.TypeHint] =
      AwsError.unwrapOptionField("typeHint", typeHint)
    def getValue: ZIO[Any, AwsError, zio.aws.rdsdata.model.Field.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.SqlParameter
  ) extends zio.aws.rdsdata.model.SqlParameter.ReadOnly {
    override val name: Option[ParameterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.rdsdata.model.primitives.ParameterName(value))
    override val typeHint: Option[zio.aws.rdsdata.model.TypeHint] = scala
      .Option(impl.typeHint())
      .map(value => zio.aws.rdsdata.model.TypeHint.wrap(value))
    override val value: Option[zio.aws.rdsdata.model.Field.ReadOnly] = scala
      .Option(impl.value())
      .map(value => zio.aws.rdsdata.model.Field.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.SqlParameter
  ): zio.aws.rdsdata.model.SqlParameter.ReadOnly = new Wrapper(impl)
}
