package zio.aws.rdsdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchExecuteStatementResponse(
    updateResults: Option[Iterable[zio.aws.rdsdata.model.UpdateResult]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementResponse = {
    import BatchExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementResponse
      .builder()
      .optionallyWith(
        updateResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updateResults)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly =
    zio.aws.rdsdata.model.BatchExecuteStatementResponse.wrap(buildAwsValue())
}
object BatchExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.BatchExecuteStatementResponse =
      zio.aws.rdsdata.model.BatchExecuteStatementResponse(
        updateResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def updateResults: Option[List[zio.aws.rdsdata.model.UpdateResult.ReadOnly]]
    def getUpdateResults: ZIO[Any, AwsError, List[
      zio.aws.rdsdata.model.UpdateResult.ReadOnly
    ]] = AwsError.unwrapOptionField("updateResults", updateResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementResponse
  ) extends zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly {
    override val updateResults
        : Option[List[zio.aws.rdsdata.model.UpdateResult.ReadOnly]] = scala
      .Option(impl.updateResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rdsdata.model.UpdateResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementResponse
  ): zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly = new Wrapper(
    impl
  )
}
