package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Id, SqlStatement, Arn, DbName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchExecuteStatementRequest(
    database: Option[DbName] = None,
    parameterSets: Option[
      Iterable[Iterable[zio.aws.rdsdata.model.SqlParameter]]
    ] = None,
    resourceArn: Arn,
    schema: Option[DbName] = None,
    secretArn: Arn,
    sql: SqlStatement,
    transactionId: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest = {
    import BatchExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
      .builder()
      .optionallyWith(
        database.map(value => DbName.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        parameterSets.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.parameterSets)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        schema.map(value => DbName.unwrap(value): java.lang.String)
      )(_.schema)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .sql(SqlStatement.unwrap(sql): java.lang.String)
      .optionallyWith(
        transactionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.BatchExecuteStatementRequest.ReadOnly =
    zio.aws.rdsdata.model.BatchExecuteStatementRequest.wrap(buildAwsValue())
}
object BatchExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.BatchExecuteStatementRequest =
      zio.aws.rdsdata.model.BatchExecuteStatementRequest(
        database.map(value => value),
        parameterSets.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        ),
        resourceArn,
        schema.map(value => value),
        secretArn,
        sql,
        transactionId.map(value => value)
      )
    def database: Option[DbName]
    def parameterSets
        : Option[List[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]]]
    def resourceArn: Arn
    def schema: Option[DbName]
    def secretArn: Arn
    def sql: SqlStatement
    def transactionId: Option[Id]
    def getDatabase: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("database", database)
    def getParameterSets: ZIO[Any, AwsError, List[
      List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]
    ]] = AwsError.unwrapOptionField("parameterSets", parameterSets)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getSchema: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("schema", schema)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getSql: ZIO[Any, Nothing, SqlStatement] = ZIO.succeed(sql)
    def getTransactionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
  ) extends zio.aws.rdsdata.model.BatchExecuteStatementRequest.ReadOnly {
    override val database: Option[DbName] = scala
      .Option(impl.database())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val parameterSets
        : Option[List[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]]] =
      scala
        .Option(impl.parameterSets())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.rdsdata.model.SqlParameter.wrap(item)
            }.toList
          }.toList
        )
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val schema: Option[DbName] = scala
      .Option(impl.schema())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val sql: SqlStatement =
      zio.aws.rdsdata.model.primitives.SqlStatement(impl.sql())
    override val transactionId: Option[Id] = scala
      .Option(impl.transactionId())
      .map(value => zio.aws.rdsdata.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
  ): zio.aws.rdsdata.model.BatchExecuteStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
