package zio.aws.rdsdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateResult(
    generatedFields: Option[Iterable[zio.aws.rdsdata.model.Field]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.UpdateResult = {
    import UpdateResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.UpdateResult
      .builder()
      .optionallyWith(
        generatedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatedFields)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.UpdateResult.ReadOnly =
    zio.aws.rdsdata.model.UpdateResult.wrap(buildAwsValue())
}
object UpdateResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.UpdateResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.UpdateResult =
      zio.aws.rdsdata.model.UpdateResult(
        generatedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def generatedFields: Option[List[zio.aws.rdsdata.model.Field.ReadOnly]]
    def getGeneratedFields
        : ZIO[Any, AwsError, List[zio.aws.rdsdata.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("generatedFields", generatedFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.UpdateResult
  ) extends zio.aws.rdsdata.model.UpdateResult.ReadOnly {
    override val generatedFields
        : Option[List[zio.aws.rdsdata.model.Field.ReadOnly]] = scala
      .Option(impl.generatedFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rdsdata.model.Field.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.UpdateResult
  ): zio.aws.rdsdata.model.UpdateResult.ReadOnly = new Wrapper(impl)
}
