package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Id, SqlStatement, Arn, DbName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementRequest(
    continueAfterTimeout: Option[Boolean] = None,
    database: Option[DbName] = None,
    includeResultMetadata: Option[Boolean] = None,
    parameters: Option[Iterable[zio.aws.rdsdata.model.SqlParameter]] = None,
    resourceArn: Arn,
    resultSetOptions: Option[zio.aws.rdsdata.model.ResultSetOptions] = None,
    schema: Option[DbName] = None,
    secretArn: Arn,
    sql: SqlStatement,
    transactionId: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest = {
    import ExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
      .builder()
      .optionallyWith(
        continueAfterTimeout.map(value => value: java.lang.Boolean)
      )(_.continueAfterTimeout)
      .optionallyWith(
        database.map(value => DbName.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        includeResultMetadata.map(value => value: java.lang.Boolean)
      )(_.includeResultMetadata)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(resultSetOptions.map(value => value.buildAwsValue()))(
        _.resultSetOptions
      )
      .optionallyWith(
        schema.map(value => DbName.unwrap(value): java.lang.String)
      )(_.schema)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .sql(SqlStatement.unwrap(sql): java.lang.String)
      .optionallyWith(
        transactionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly =
    zio.aws.rdsdata.model.ExecuteStatementRequest.wrap(buildAwsValue())
}
object ExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ExecuteStatementRequest =
      zio.aws.rdsdata.model.ExecuteStatementRequest(
        continueAfterTimeout.map(value => value),
        database.map(value => value),
        includeResultMetadata.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceArn,
        resultSetOptions.map(value => value.asEditable),
        schema.map(value => value),
        secretArn,
        sql,
        transactionId.map(value => value)
      )
    def continueAfterTimeout: Option[Boolean]
    def database: Option[DbName]
    def includeResultMetadata: Option[Boolean]
    def parameters: Option[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]]
    def resourceArn: Arn
    def resultSetOptions
        : Option[zio.aws.rdsdata.model.ResultSetOptions.ReadOnly]
    def schema: Option[DbName]
    def secretArn: Arn
    def sql: SqlStatement
    def transactionId: Option[Id]
    def getContinueAfterTimeout: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("continueAfterTimeout", continueAfterTimeout)
    def getDatabase: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("database", database)
    def getIncludeResultMetadata: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeResultMetadata", includeResultMetadata)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.rdsdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getResultSetOptions
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.ResultSetOptions.ReadOnly] =
      AwsError.unwrapOptionField("resultSetOptions", resultSetOptions)
    def getSchema: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("schema", schema)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getSql: ZIO[Any, Nothing, SqlStatement] = ZIO.succeed(sql)
    def getTransactionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ) extends zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly {
    override val continueAfterTimeout: Option[Boolean] =
      scala.Option(impl.continueAfterTimeout()).map(value => value: Boolean)
    override val database: Option[DbName] = scala
      .Option(impl.database())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val includeResultMetadata: Option[Boolean] =
      scala.Option(impl.includeResultMetadata()).map(value => value: Boolean)
    override val parameters
        : Option[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rdsdata.model.SqlParameter.wrap(item)
        }.toList
      )
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val resultSetOptions
        : Option[zio.aws.rdsdata.model.ResultSetOptions.ReadOnly] = scala
      .Option(impl.resultSetOptions())
      .map(value => zio.aws.rdsdata.model.ResultSetOptions.wrap(value))
    override val schema: Option[DbName] = scala
      .Option(impl.schema())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val sql: SqlStatement =
      zio.aws.rdsdata.model.primitives.SqlStatement(impl.sql())
    override val transactionId: Option[Id] = scala
      .Option(impl.transactionId())
      .map(value => zio.aws.rdsdata.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ): zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly = new Wrapper(impl)
}
