package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.TransactionStatus
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CommitTransactionResponse(
    transactionStatus: Optional[TransactionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.CommitTransactionResponse = {
    import CommitTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.CommitTransactionResponse
      .builder()
      .optionallyWith(
        transactionStatus.map(value =>
          TransactionStatus.unwrap(value): java.lang.String
        )
      )(_.transactionStatus)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly =
    zio.aws.rdsdata.model.CommitTransactionResponse.wrap(buildAwsValue())
}
object CommitTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.CommitTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.CommitTransactionResponse =
      zio.aws.rdsdata.model
        .CommitTransactionResponse(transactionStatus.map(value => value))
    def transactionStatus: Optional[TransactionStatus]
    def getTransactionStatus: ZIO[Any, AwsError, TransactionStatus] =
      AwsError.unwrapOptionField("transactionStatus", transactionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.CommitTransactionResponse
  ) extends zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly {
    override val transactionStatus: Optional[TransactionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionStatus())
        .map(value => zio.aws.rdsdata.model.primitives.TransactionStatus(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.CommitTransactionResponse
  ): zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly = new Wrapper(
    impl
  )
}
