package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BeginTransactionResponse(
    transactionId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.BeginTransactionResponse = {
    import BeginTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.BeginTransactionResponse
      .builder()
      .optionallyWith(
        transactionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly =
    zio.aws.rdsdata.model.BeginTransactionResponse.wrap(buildAwsValue())
}
object BeginTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.BeginTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.BeginTransactionResponse =
      zio.aws.rdsdata.model
        .BeginTransactionResponse(transactionId.map(value => value))
    def transactionId: Optional[Id]
    def getTransactionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.BeginTransactionResponse
  ) extends zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly {
    override val transactionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => zio.aws.rdsdata.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.BeginTransactionResponse
  ): zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly = new Wrapper(impl)
}
