package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ColumnMetadata(
    arrayBaseColumnType: Option[Integer] = None,
    isAutoIncrement: Option[Boolean] = None,
    isCaseSensitive: Option[Boolean] = None,
    isCurrency: Option[Boolean] = None,
    isSigned: Option[Boolean] = None,
    label: Option[String] = None,
    name: Option[String] = None,
    nullable: Option[Integer] = None,
    precision: Option[Integer] = None,
    scale: Option[Integer] = None,
    schemaName: Option[String] = None,
    tableName: Option[String] = None,
    `type`: Option[Integer] = None,
    typeName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ColumnMetadata = {
    import ColumnMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
      .builder()
      .optionallyWith(
        arrayBaseColumnType.map(value => value: java.lang.Integer)
      )(_.arrayBaseColumnType)
      .optionallyWith(isAutoIncrement.map(value => value: java.lang.Boolean))(
        _.isAutoIncrement
      )
      .optionallyWith(isCaseSensitive.map(value => value: java.lang.Boolean))(
        _.isCaseSensitive
      )
      .optionallyWith(isCurrency.map(value => value: java.lang.Boolean))(
        _.isCurrency
      )
      .optionallyWith(isSigned.map(value => value: java.lang.Boolean))(
        _.isSigned
      )
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(nullable.map(value => value: java.lang.Integer))(
        _.nullable
      )
      .optionallyWith(precision.map(value => value: java.lang.Integer))(
        _.precision
      )
      .optionallyWith(scale.map(value => value: java.lang.Integer))(_.scale)
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .optionallyWith(`type`.map(value => value: java.lang.Integer))(_.`type`)
      .optionallyWith(typeName.map(value => value: java.lang.String))(
        _.typeName
      )
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ColumnMetadata.ReadOnly =
    zio.aws.rdsdata.model.ColumnMetadata.wrap(buildAwsValue())
}
object ColumnMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ColumnMetadata =
      zio.aws.rdsdata.model.ColumnMetadata(
        arrayBaseColumnType.map(value => value),
        isAutoIncrement.map(value => value),
        isCaseSensitive.map(value => value),
        isCurrency.map(value => value),
        isSigned.map(value => value),
        label.map(value => value),
        name.map(value => value),
        nullable.map(value => value),
        precision.map(value => value),
        scale.map(value => value),
        schemaName.map(value => value),
        tableName.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value)
      )
    def arrayBaseColumnType: Option[Integer]
    def isAutoIncrement: Option[Boolean]
    def isCaseSensitive: Option[Boolean]
    def isCurrency: Option[Boolean]
    def isSigned: Option[Boolean]
    def label: Option[String]
    def name: Option[String]
    def nullable: Option[Integer]
    def precision: Option[Integer]
    def scale: Option[Integer]
    def schemaName: Option[String]
    def tableName: Option[String]
    def `type`: Option[Integer]
    def typeName: Option[String]
    def getArrayBaseColumnType: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("arrayBaseColumnType", arrayBaseColumnType)
    def getIsAutoIncrement: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAutoIncrement", isAutoIncrement)
    def getIsCaseSensitive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCaseSensitive", isCaseSensitive)
    def getIsCurrency: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCurrency", isCurrency)
    def getIsSigned: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSigned", isSigned)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNullable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nullable", nullable)
    def getPrecision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("precision", precision)
    def getScale: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scale", scale)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getType: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("typeName", typeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
  ) extends zio.aws.rdsdata.model.ColumnMetadata.ReadOnly {
    override val arrayBaseColumnType: Option[Integer] =
      scala.Option(impl.arrayBaseColumnType()).map(value => value: Integer)
    override val isAutoIncrement: Option[Boolean] =
      scala.Option(impl.isAutoIncrement()).map(value => value: Boolean)
    override val isCaseSensitive: Option[Boolean] =
      scala.Option(impl.isCaseSensitive()).map(value => value: Boolean)
    override val isCurrency: Option[Boolean] =
      scala.Option(impl.isCurrency()).map(value => value: Boolean)
    override val isSigned: Option[Boolean] =
      scala.Option(impl.isSigned()).map(value => value: Boolean)
    override val label: Option[String] =
      scala.Option(impl.label()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val nullable: Option[Integer] =
      scala.Option(impl.nullable()).map(value => value: Integer)
    override val precision: Option[Integer] =
      scala.Option(impl.precision()).map(value => value: Integer)
    override val scale: Option[Integer] =
      scala.Option(impl.scale()).map(value => value: Integer)
    override val schemaName: Option[String] =
      scala.Option(impl.schemaName()).map(value => value: String)
    override val tableName: Option[String] =
      scala.Option(impl.tableName()).map(value => value: String)
    override val `type`: Option[Integer] =
      scala.Option(impl.`type`()).map(value => value: Integer)
    override val typeName: Option[String] =
      scala.Option(impl.typeName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
  ): zio.aws.rdsdata.model.ColumnMetadata.ReadOnly = new Wrapper(impl)
}
