package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.TransactionStatus
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RollbackTransactionResponse(
    transactionStatus: Option[TransactionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.RollbackTransactionResponse = {
    import RollbackTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.RollbackTransactionResponse
      .builder()
      .optionallyWith(
        transactionStatus.map(value =>
          TransactionStatus.unwrap(value): java.lang.String
        )
      )(_.transactionStatus)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly =
    zio.aws.rdsdata.model.RollbackTransactionResponse.wrap(buildAwsValue())
}
object RollbackTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.RollbackTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.RollbackTransactionResponse =
      zio.aws.rdsdata.model
        .RollbackTransactionResponse(transactionStatus.map(value => value))
    def transactionStatus: Option[TransactionStatus]
    def getTransactionStatus: ZIO[Any, AwsError, TransactionStatus] =
      AwsError.unwrapOptionField("transactionStatus", transactionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.RollbackTransactionResponse
  ) extends zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly {
    override val transactionStatus: Option[TransactionStatus] = scala
      .Option(impl.transactionStatus())
      .map(value => zio.aws.rdsdata.model.primitives.TransactionStatus(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.RollbackTransactionResponse
  ): zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly = new Wrapper(
    impl
  )
}
