package zio.aws.rdsdata.model
import scala.jdk.CollectionConverters._
sealed trait RecordsFormatType {
  def unwrap: software.amazon.awssdk.services.rdsdata.model.RecordsFormatType
}
object RecordsFormatType {
  def wrap(
      value: software.amazon.awssdk.services.rdsdata.model.RecordsFormatType
  ): zio.aws.rdsdata.model.RecordsFormatType = value match {
    case software.amazon.awssdk.services.rdsdata.model.RecordsFormatType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rdsdata.model.RecordsFormatType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.rdsdata.model.RecordsFormatType.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rdsdata.model.RecordsFormatType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.RecordsFormatType =
      software.amazon.awssdk.services.rdsdata.model.RecordsFormatType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.rdsdata.model.RecordsFormatType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.RecordsFormatType =
      software.amazon.awssdk.services.rdsdata.model.RecordsFormatType.NONE
  }
  case object JSON extends zio.aws.rdsdata.model.RecordsFormatType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.RecordsFormatType =
      software.amazon.awssdk.services.rdsdata.model.RecordsFormatType.JSON
  }
}
