package zio.aws.rdsdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResultSetOptions(
    decimalReturnType: Optional[zio.aws.rdsdata.model.DecimalReturnType] =
      Optional.Absent,
    longReturnType: Optional[zio.aws.rdsdata.model.LongReturnType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ResultSetOptions = {
    import ResultSetOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
      .builder()
      .optionallyWith(decimalReturnType.map(value => value.unwrap))(
        _.decimalReturnType
      )
      .optionallyWith(longReturnType.map(value => value.unwrap))(
        _.longReturnType
      )
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ResultSetOptions.ReadOnly =
    zio.aws.rdsdata.model.ResultSetOptions.wrap(buildAwsValue())
}
object ResultSetOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ResultSetOptions =
      zio.aws.rdsdata.model.ResultSetOptions(
        decimalReturnType.map(value => value),
        longReturnType.map(value => value)
      )
    def decimalReturnType: Optional[zio.aws.rdsdata.model.DecimalReturnType]
    def longReturnType: Optional[zio.aws.rdsdata.model.LongReturnType]
    def getDecimalReturnType
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.DecimalReturnType] =
      AwsError.unwrapOptionField("decimalReturnType", decimalReturnType)
    def getLongReturnType
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.LongReturnType] =
      AwsError.unwrapOptionField("longReturnType", longReturnType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
  ) extends zio.aws.rdsdata.model.ResultSetOptions.ReadOnly {
    override val decimalReturnType
        : Optional[zio.aws.rdsdata.model.DecimalReturnType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.decimalReturnType())
        .map(value => zio.aws.rdsdata.model.DecimalReturnType.wrap(value))
    override val longReturnType
        : Optional[zio.aws.rdsdata.model.LongReturnType] = zio.aws.core.internal
      .optionalFromNullable(impl.longReturnType())
      .map(value => zio.aws.rdsdata.model.LongReturnType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
  ): zio.aws.rdsdata.model.ResultSetOptions.ReadOnly = new Wrapper(impl)
}
