package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.ParameterName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SqlParameter(
    name: Optional[ParameterName] = Optional.Absent,
    value: Optional[zio.aws.rdsdata.model.Field] = Optional.Absent,
    typeHint: Optional[zio.aws.rdsdata.model.TypeHint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.SqlParameter = {
    import SqlParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.SqlParameter
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(typeHint.map(value => value.unwrap))(_.typeHint)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.SqlParameter.ReadOnly =
    zio.aws.rdsdata.model.SqlParameter.wrap(buildAwsValue())
}
object SqlParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.SqlParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.SqlParameter =
      zio.aws.rdsdata.model.SqlParameter(
        name.map(value => value),
        value.map(value => value.asEditable),
        typeHint.map(value => value)
      )
    def name: Optional[ParameterName]
    def value: Optional[zio.aws.rdsdata.model.Field.ReadOnly]
    def typeHint: Optional[zio.aws.rdsdata.model.TypeHint]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, zio.aws.rdsdata.model.Field.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getTypeHint: ZIO[Any, AwsError, zio.aws.rdsdata.model.TypeHint] =
      AwsError.unwrapOptionField("typeHint", typeHint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.SqlParameter
  ) extends zio.aws.rdsdata.model.SqlParameter.ReadOnly {
    override val name: Optional[ParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.rdsdata.model.primitives.ParameterName(value))
    override val value: Optional[zio.aws.rdsdata.model.Field.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.rdsdata.model.Field.wrap(value))
    override val typeHint: Optional[zio.aws.rdsdata.model.TypeHint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeHint())
        .map(value => zio.aws.rdsdata.model.TypeHint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.SqlParameter
  ): zio.aws.rdsdata.model.SqlParameter.ReadOnly = new Wrapper(impl)
}
