package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Id, DbName, SqlStatement, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchExecuteStatementRequest(
    resourceArn: Arn,
    secretArn: Arn,
    sql: SqlStatement,
    database: Optional[DbName] = Optional.Absent,
    schema: Optional[DbName] = Optional.Absent,
    parameterSets: Optional[
      Iterable[Iterable[zio.aws.rdsdata.model.SqlParameter]]
    ] = Optional.Absent,
    transactionId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest = {
    import BatchExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .sql(SqlStatement.unwrap(sql): java.lang.String)
      .optionallyWith(
        database.map(value => DbName.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        schema.map(value => DbName.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        parameterSets.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.parameterSets)
      .optionallyWith(
        transactionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.BatchExecuteStatementRequest.ReadOnly =
    zio.aws.rdsdata.model.BatchExecuteStatementRequest.wrap(buildAwsValue())
}
object BatchExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.BatchExecuteStatementRequest =
      zio.aws.rdsdata.model.BatchExecuteStatementRequest(
        resourceArn,
        secretArn,
        sql,
        database.map(value => value),
        schema.map(value => value),
        parameterSets.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        ),
        transactionId.map(value => value)
      )
    def resourceArn: Arn
    def secretArn: Arn
    def sql: SqlStatement
    def database: Optional[DbName]
    def schema: Optional[DbName]
    def parameterSets
        : Optional[List[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]]]
    def transactionId: Optional[Id]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getSql: ZIO[Any, Nothing, SqlStatement] = ZIO.succeed(sql)
    def getDatabase: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("database", database)
    def getSchema: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("schema", schema)
    def getParameterSets: ZIO[Any, AwsError, List[
      List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]
    ]] = AwsError.unwrapOptionField("parameterSets", parameterSets)
    def getTransactionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
  ) extends zio.aws.rdsdata.model.BatchExecuteStatementRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val sql: SqlStatement =
      zio.aws.rdsdata.model.primitives.SqlStatement(impl.sql())
    override val database: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val schema: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val parameterSets
        : Optional[List[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterSets())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.rdsdata.model.SqlParameter.wrap(item)
            }.toList
          }.toList
        )
    override val transactionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => zio.aws.rdsdata.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest
  ): zio.aws.rdsdata.model.BatchExecuteStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
