package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{
  Blob,
  BoxedDouble,
  BoxedLong,
  BoxedBoolean
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Field(
    isNull: Optional[BoxedBoolean] = Optional.Absent,
    booleanValue: Optional[BoxedBoolean] = Optional.Absent,
    longValue: Optional[BoxedLong] = Optional.Absent,
    doubleValue: Optional[BoxedDouble] = Optional.Absent,
    stringValue: Optional[String] = Optional.Absent,
    blobValue: Optional[Blob] = Optional.Absent,
    arrayValue: Optional[zio.aws.rdsdata.model.ArrayValue] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rdsdata.model.Field = {
    import Field.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.Field
      .builder()
      .optionallyWith(isNull.map(value => value: java.lang.Boolean))(_.isNull)
      .optionallyWith(booleanValue.map(value => value: java.lang.Boolean))(
        _.booleanValue
      )
      .optionallyWith(longValue.map(value => value: java.lang.Long))(
        _.longValue
      )
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .optionallyWith(
        blobValue.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.blobValue)
      .optionallyWith(arrayValue.map(value => value.buildAwsValue()))(
        _.arrayValue
      )
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.Field.ReadOnly =
    zio.aws.rdsdata.model.Field.wrap(buildAwsValue())
}
object Field {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rdsdata.model.Field] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.Field = zio.aws.rdsdata.model.Field(
      isNull.map(value => value),
      booleanValue.map(value => value),
      longValue.map(value => value),
      doubleValue.map(value => value),
      stringValue.map(value => value),
      blobValue.map(value => value),
      arrayValue.map(value => value.asEditable)
    )
    def isNull: Optional[BoxedBoolean]
    def booleanValue: Optional[BoxedBoolean]
    def longValue: Optional[BoxedLong]
    def doubleValue: Optional[BoxedDouble]
    def stringValue: Optional[String]
    def blobValue: Optional[Blob]
    def arrayValue: Optional[zio.aws.rdsdata.model.ArrayValue.ReadOnly]
    def getIsNull: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("isNull", isNull)
    def getBooleanValue: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getLongValue: ZIO[Any, AwsError, BoxedLong] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getDoubleValue: ZIO[Any, AwsError, BoxedDouble] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getBlobValue: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blobValue", blobValue)
    def getArrayValue
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.ArrayValue.ReadOnly] =
      AwsError.unwrapOptionField("arrayValue", arrayValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.Field
  ) extends zio.aws.rdsdata.model.Field.ReadOnly {
    override val isNull: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isNull())
      .map(value => value: BoxedBoolean)
    override val booleanValue: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.booleanValue())
      .map(value => value: BoxedBoolean)
    override val longValue: Optional[BoxedLong] = zio.aws.core.internal
      .optionalFromNullable(impl.longValue())
      .map(value => value: BoxedLong)
    override val doubleValue: Optional[BoxedDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.doubleValue())
      .map(value => value: BoxedDouble)
    override val stringValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value => value: String)
    override val blobValue: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.blobValue())
      .map(value =>
        zio.aws.rdsdata.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val arrayValue
        : Optional[zio.aws.rdsdata.model.ArrayValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arrayValue())
        .map(value => zio.aws.rdsdata.model.ArrayValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.Field
  ): zio.aws.rdsdata.model.Field.ReadOnly = new Wrapper(impl)
}
