package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Id, DbName, SqlStatement, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecuteStatementRequest(
    resourceArn: Arn,
    secretArn: Arn,
    sql: SqlStatement,
    database: Optional[DbName] = Optional.Absent,
    schema: Optional[DbName] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.rdsdata.model.SqlParameter]] =
      Optional.Absent,
    transactionId: Optional[Id] = Optional.Absent,
    includeResultMetadata: Optional[Boolean] = Optional.Absent,
    continueAfterTimeout: Optional[Boolean] = Optional.Absent,
    resultSetOptions: Optional[zio.aws.rdsdata.model.ResultSetOptions] =
      Optional.Absent,
    formatRecordsAs: Optional[zio.aws.rdsdata.model.RecordsFormatType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest = {
    import ExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .sql(SqlStatement.unwrap(sql): java.lang.String)
      .optionallyWith(
        database.map(value => DbName.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        schema.map(value => DbName.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        transactionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.transactionId)
      .optionallyWith(
        includeResultMetadata.map(value => value: java.lang.Boolean)
      )(_.includeResultMetadata)
      .optionallyWith(
        continueAfterTimeout.map(value => value: java.lang.Boolean)
      )(_.continueAfterTimeout)
      .optionallyWith(resultSetOptions.map(value => value.buildAwsValue()))(
        _.resultSetOptions
      )
      .optionallyWith(formatRecordsAs.map(value => value.unwrap))(
        _.formatRecordsAs
      )
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly =
    zio.aws.rdsdata.model.ExecuteStatementRequest.wrap(buildAwsValue())
}
object ExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ExecuteStatementRequest =
      zio.aws.rdsdata.model.ExecuteStatementRequest(
        resourceArn,
        secretArn,
        sql,
        database.map(value => value),
        schema.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        transactionId.map(value => value),
        includeResultMetadata.map(value => value),
        continueAfterTimeout.map(value => value),
        resultSetOptions.map(value => value.asEditable),
        formatRecordsAs.map(value => value)
      )
    def resourceArn: Arn
    def secretArn: Arn
    def sql: SqlStatement
    def database: Optional[DbName]
    def schema: Optional[DbName]
    def parameters: Optional[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]]
    def transactionId: Optional[Id]
    def includeResultMetadata: Optional[Boolean]
    def continueAfterTimeout: Optional[Boolean]
    def resultSetOptions
        : Optional[zio.aws.rdsdata.model.ResultSetOptions.ReadOnly]
    def formatRecordsAs: Optional[zio.aws.rdsdata.model.RecordsFormatType]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getSql: ZIO[Any, Nothing, SqlStatement] = ZIO.succeed(sql)
    def getDatabase: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("database", database)
    def getSchema: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("schema", schema)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.rdsdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getTransactionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("transactionId", transactionId)
    def getIncludeResultMetadata: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeResultMetadata", includeResultMetadata)
    def getContinueAfterTimeout: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("continueAfterTimeout", continueAfterTimeout)
    def getResultSetOptions
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.ResultSetOptions.ReadOnly] =
      AwsError.unwrapOptionField("resultSetOptions", resultSetOptions)
    def getFormatRecordsAs
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.RecordsFormatType] =
      AwsError.unwrapOptionField("formatRecordsAs", formatRecordsAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ) extends zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val sql: SqlStatement =
      zio.aws.rdsdata.model.primitives.SqlStatement(impl.sql())
    override val database: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val schema: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val parameters
        : Optional[List[zio.aws.rdsdata.model.SqlParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rdsdata.model.SqlParameter.wrap(item)
          }.toList
        )
    override val transactionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => zio.aws.rdsdata.model.primitives.Id(value))
    override val includeResultMetadata: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeResultMetadata())
        .map(value => value: Boolean)
    override val continueAfterTimeout: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.continueAfterTimeout())
      .map(value => value: Boolean)
    override val resultSetOptions
        : Optional[zio.aws.rdsdata.model.ResultSetOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultSetOptions())
        .map(value => zio.aws.rdsdata.model.ResultSetOptions.wrap(value))
    override val formatRecordsAs
        : Optional[zio.aws.rdsdata.model.RecordsFormatType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatRecordsAs())
        .map(value => zio.aws.rdsdata.model.RecordsFormatType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest
  ): zio.aws.rdsdata.model.ExecuteStatementRequest.ReadOnly = new Wrapper(impl)
}
