package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ColumnMetadata(
    arrayBaseColumnType: Optional[Integer] = Optional.Absent,
    isAutoIncrement: Optional[Boolean] = Optional.Absent,
    isCaseSensitive: Optional[Boolean] = Optional.Absent,
    isCurrency: Optional[Boolean] = Optional.Absent,
    isSigned: Optional[Boolean] = Optional.Absent,
    label: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    nullable: Optional[Integer] = Optional.Absent,
    precision: Optional[Integer] = Optional.Absent,
    scale: Optional[Integer] = Optional.Absent,
    schemaName: Optional[String] = Optional.Absent,
    tableName: Optional[String] = Optional.Absent,
    `type`: Optional[Integer] = Optional.Absent,
    typeName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ColumnMetadata = {
    import ColumnMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
      .builder()
      .optionallyWith(
        arrayBaseColumnType.map(value => value: java.lang.Integer)
      )(_.arrayBaseColumnType)
      .optionallyWith(isAutoIncrement.map(value => value: java.lang.Boolean))(
        _.isAutoIncrement
      )
      .optionallyWith(isCaseSensitive.map(value => value: java.lang.Boolean))(
        _.isCaseSensitive
      )
      .optionallyWith(isCurrency.map(value => value: java.lang.Boolean))(
        _.isCurrency
      )
      .optionallyWith(isSigned.map(value => value: java.lang.Boolean))(
        _.isSigned
      )
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(nullable.map(value => value: java.lang.Integer))(
        _.nullable
      )
      .optionallyWith(precision.map(value => value: java.lang.Integer))(
        _.precision
      )
      .optionallyWith(scale.map(value => value: java.lang.Integer))(_.scale)
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .optionallyWith(`type`.map(value => value: java.lang.Integer))(_.`type`)
      .optionallyWith(typeName.map(value => value: java.lang.String))(
        _.typeName
      )
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ColumnMetadata.ReadOnly =
    zio.aws.rdsdata.model.ColumnMetadata.wrap(buildAwsValue())
}
object ColumnMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ColumnMetadata =
      zio.aws.rdsdata.model.ColumnMetadata(
        arrayBaseColumnType.map(value => value),
        isAutoIncrement.map(value => value),
        isCaseSensitive.map(value => value),
        isCurrency.map(value => value),
        isSigned.map(value => value),
        label.map(value => value),
        name.map(value => value),
        nullable.map(value => value),
        precision.map(value => value),
        scale.map(value => value),
        schemaName.map(value => value),
        tableName.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value)
      )
    def arrayBaseColumnType: Optional[Integer]
    def isAutoIncrement: Optional[Boolean]
    def isCaseSensitive: Optional[Boolean]
    def isCurrency: Optional[Boolean]
    def isSigned: Optional[Boolean]
    def label: Optional[String]
    def name: Optional[String]
    def nullable: Optional[Integer]
    def precision: Optional[Integer]
    def scale: Optional[Integer]
    def schemaName: Optional[String]
    def tableName: Optional[String]
    def `type`: Optional[Integer]
    def typeName: Optional[String]
    def getArrayBaseColumnType: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("arrayBaseColumnType", arrayBaseColumnType)
    def getIsAutoIncrement: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAutoIncrement", isAutoIncrement)
    def getIsCaseSensitive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCaseSensitive", isCaseSensitive)
    def getIsCurrency: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCurrency", isCurrency)
    def getIsSigned: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSigned", isSigned)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNullable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nullable", nullable)
    def getPrecision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("precision", precision)
    def getScale: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scale", scale)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getType: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("typeName", typeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
  ) extends zio.aws.rdsdata.model.ColumnMetadata.ReadOnly {
    override val arrayBaseColumnType: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.arrayBaseColumnType())
      .map(value => value: Integer)
    override val isAutoIncrement: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAutoIncrement())
      .map(value => value: Boolean)
    override val isCaseSensitive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isCaseSensitive())
      .map(value => value: Boolean)
    override val isCurrency: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isCurrency())
      .map(value => value: Boolean)
    override val isSigned: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSigned())
      .map(value => value: Boolean)
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val nullable: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.nullable())
      .map(value => value: Integer)
    override val precision: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.precision())
      .map(value => value: Integer)
    override val scale: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scale())
      .map(value => value: Integer)
    override val schemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: String)
    override val tableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => value: String)
    override val `type`: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: Integer)
    override val typeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ColumnMetadata
  ): zio.aws.rdsdata.model.ColumnMetadata.ReadOnly = new Wrapper(impl)
}
