package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{RecordsUpdated, FormattedSqlRecords}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecuteStatementResponse(
    columnMetadata: Optional[Iterable[zio.aws.rdsdata.model.ColumnMetadata]] =
      Optional.Absent,
    formattedRecords: Optional[FormattedSqlRecords] = Optional.Absent,
    generatedFields: Optional[Iterable[zio.aws.rdsdata.model.Field]] =
      Optional.Absent,
    numberOfRecordsUpdated: Optional[RecordsUpdated] = Optional.Absent,
    records: Optional[Iterable[Iterable[zio.aws.rdsdata.model.Field]]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse = {
    import ExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
      .builder()
      .optionallyWith(
        columnMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnMetadata)
      .optionallyWith(
        formattedRecords.map(value =>
          FormattedSqlRecords.unwrap(value): java.lang.String
        )
      )(_.formattedRecords)
      .optionallyWith(
        generatedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatedFields)
      .optionallyWith(
        numberOfRecordsUpdated.map(value =>
          RecordsUpdated.unwrap(value): java.lang.Long
        )
      )(_.numberOfRecordsUpdated)
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.records)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly =
    zio.aws.rdsdata.model.ExecuteStatementResponse.wrap(buildAwsValue())
}
object ExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ExecuteStatementResponse =
      zio.aws.rdsdata.model.ExecuteStatementResponse(
        columnMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        formattedRecords.map(value => value),
        generatedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        numberOfRecordsUpdated.map(value => value),
        records.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        )
      )
    def columnMetadata
        : Optional[List[zio.aws.rdsdata.model.ColumnMetadata.ReadOnly]]
    def formattedRecords: Optional[FormattedSqlRecords]
    def generatedFields: Optional[List[zio.aws.rdsdata.model.Field.ReadOnly]]
    def numberOfRecordsUpdated: Optional[RecordsUpdated]
    def records: Optional[List[List[zio.aws.rdsdata.model.Field.ReadOnly]]]
    def getColumnMetadata: ZIO[Any, AwsError, List[
      zio.aws.rdsdata.model.ColumnMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("columnMetadata", columnMetadata)
    def getFormattedRecords: ZIO[Any, AwsError, FormattedSqlRecords] =
      AwsError.unwrapOptionField("formattedRecords", formattedRecords)
    def getGeneratedFields
        : ZIO[Any, AwsError, List[zio.aws.rdsdata.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("generatedFields", generatedFields)
    def getNumberOfRecordsUpdated: ZIO[Any, AwsError, RecordsUpdated] = AwsError
      .unwrapOptionField("numberOfRecordsUpdated", numberOfRecordsUpdated)
    def getRecords
        : ZIO[Any, AwsError, List[List[zio.aws.rdsdata.model.Field.ReadOnly]]] =
      AwsError.unwrapOptionField("records", records)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
  ) extends zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly {
    override val columnMetadata
        : Optional[List[zio.aws.rdsdata.model.ColumnMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rdsdata.model.ColumnMetadata.wrap(item)
          }.toList
        )
    override val formattedRecords: Optional[FormattedSqlRecords] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formattedRecords())
        .map(value =>
          zio.aws.rdsdata.model.primitives.FormattedSqlRecords(value)
        )
    override val generatedFields
        : Optional[List[zio.aws.rdsdata.model.Field.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generatedFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rdsdata.model.Field.wrap(item)
          }.toList
        )
    override val numberOfRecordsUpdated: Optional[RecordsUpdated] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfRecordsUpdated())
        .map(value => zio.aws.rdsdata.model.primitives.RecordsUpdated(value))
    override val records
        : Optional[List[List[zio.aws.rdsdata.model.Field.ReadOnly]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.records())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.rdsdata.model.Field.wrap(item)
            }.toList
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse
  ): zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly = new Wrapper(impl)
}
