package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{BoxedLong, BoxedDouble, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ArrayValue(
    arrayValues: Option[Iterable[zio.aws.rdsdata.model.ArrayValue]] = None,
    booleanValues: Option[Iterable[BoxedBoolean]] = None,
    doubleValues: Option[Iterable[BoxedDouble]] = None,
    longValues: Option[Iterable[BoxedLong]] = None,
    stringValues: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ArrayValue = {
    import ArrayValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ArrayValue
      .builder()
      .optionallyWith(
        arrayValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.arrayValues)
      .optionallyWith(
        booleanValues.map(value =>
          value.map { item =>
            item: java.lang.Boolean
          }.asJavaCollection
        )
      )(_.booleanValues)
      .optionallyWith(
        doubleValues.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.doubleValues)
      .optionallyWith(
        longValues.map(value =>
          value.map { item =>
            item: java.lang.Long
          }.asJavaCollection
        )
      )(_.longValues)
      .optionallyWith(
        stringValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stringValues)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ArrayValue.ReadOnly =
    zio.aws.rdsdata.model.ArrayValue.wrap(buildAwsValue())
}
object ArrayValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ArrayValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ArrayValue =
      zio.aws.rdsdata.model.ArrayValue(
        arrayValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        booleanValues.map(value => value),
        doubleValues.map(value => value),
        longValues.map(value => value),
        stringValues.map(value => value)
      )
    def arrayValues: Option[List[zio.aws.rdsdata.model.ArrayValue.ReadOnly]]
    def booleanValues: Option[List[BoxedBoolean]]
    def doubleValues: Option[List[BoxedDouble]]
    def longValues: Option[List[BoxedLong]]
    def stringValues: Option[List[String]]
    def getArrayValues
        : ZIO[Any, AwsError, List[zio.aws.rdsdata.model.ArrayValue.ReadOnly]] =
      AwsError.unwrapOptionField("arrayValues", arrayValues)
    def getBooleanValues: ZIO[Any, AwsError, List[BoxedBoolean]] =
      AwsError.unwrapOptionField("booleanValues", booleanValues)
    def getDoubleValues: ZIO[Any, AwsError, List[BoxedDouble]] =
      AwsError.unwrapOptionField("doubleValues", doubleValues)
    def getLongValues: ZIO[Any, AwsError, List[BoxedLong]] =
      AwsError.unwrapOptionField("longValues", longValues)
    def getStringValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stringValues", stringValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ArrayValue
  ) extends zio.aws.rdsdata.model.ArrayValue.ReadOnly {
    override val arrayValues
        : Option[List[zio.aws.rdsdata.model.ArrayValue.ReadOnly]] = scala
      .Option(impl.arrayValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rdsdata.model.ArrayValue.wrap(item)
        }.toList
      )
    override val booleanValues: Option[List[BoxedBoolean]] = scala
      .Option(impl.booleanValues())
      .map(value =>
        value.asScala.map { item =>
          item: BoxedBoolean
        }.toList
      )
    override val doubleValues: Option[List[BoxedDouble]] = scala
      .Option(impl.doubleValues())
      .map(value =>
        value.asScala.map { item =>
          item: BoxedDouble
        }.toList
      )
    override val longValues: Option[List[BoxedLong]] = scala
      .Option(impl.longValues())
      .map(value =>
        value.asScala.map { item =>
          item: BoxedLong
        }.toList
      )
    override val stringValues: Option[List[String]] = scala
      .Option(impl.stringValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ArrayValue
  ): zio.aws.rdsdata.model.ArrayValue.ReadOnly = new Wrapper(impl)
}
