package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Arn, DbName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BeginTransactionRequest(
    database: Option[DbName] = None,
    resourceArn: Arn,
    schema: Option[DbName] = None,
    secretArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest = {
    import BeginTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
      .builder()
      .optionallyWith(
        database.map(value => DbName.unwrap(value): java.lang.String)
      )(_.database)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        schema.map(value => DbName.unwrap(value): java.lang.String)
      )(_.schema)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.BeginTransactionRequest.ReadOnly =
    zio.aws.rdsdata.model.BeginTransactionRequest.wrap(buildAwsValue())
}
object BeginTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.BeginTransactionRequest =
      zio.aws.rdsdata.model.BeginTransactionRequest(
        database.map(value => value),
        resourceArn,
        schema.map(value => value),
        secretArn
      )
    def database: Option[DbName]
    def resourceArn: Arn
    def schema: Option[DbName]
    def secretArn: Arn
    def getDatabase: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("database", database)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getSchema: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("schema", schema)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
  ) extends zio.aws.rdsdata.model.BeginTransactionRequest.ReadOnly {
    override val database: Option[DbName] = scala
      .Option(impl.database())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val schema: Option[DbName] = scala
      .Option(impl.schema())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
  ): zio.aws.rdsdata.model.BeginTransactionRequest.ReadOnly = new Wrapper(impl)
}
