package zio.aws.rdsdata
import zio.aws.rdsdata.model.ExecuteStatementResponse.ReadOnly
import software.amazon.awssdk.services.rdsdata.RdsDataAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.rdsdata.model.{
  ExecuteStatementRequest,
  BeginTransactionRequest,
  RollbackTransactionRequest,
  CommitTransactionRequest,
  BatchExecuteStatementRequest
}
import zio.test.mock.{Proxy, Mock}
object RdsDataMock extends Mock[RdsData] {
  object CommitTransaction
      extends Effect[
        CommitTransactionRequest,
        AwsError,
        zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly
      ]
  object RollbackTransaction
      extends Effect[
        RollbackTransactionRequest,
        AwsError,
        zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly
      ]
  object BatchExecuteStatement
      extends Effect[
        BatchExecuteStatementRequest,
        AwsError,
        zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly
      ]
  object ExecuteStatement
      extends Effect[ExecuteStatementRequest, AwsError, ReadOnly]
  object BeginTransaction
      extends Effect[
        BeginTransactionRequest,
        AwsError,
        zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, RdsData] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new RdsData {
          val api: RdsDataAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : RdsData = this
          def commitTransaction(request: CommitTransactionRequest): IO[
            AwsError,
            zio.aws.rdsdata.model.CommitTransactionResponse.ReadOnly
          ] = proxy(CommitTransaction, request)
          def rollbackTransaction(request: RollbackTransactionRequest): IO[
            AwsError,
            zio.aws.rdsdata.model.RollbackTransactionResponse.ReadOnly
          ] = proxy(RollbackTransaction, request)
          def batchExecuteStatement(request: BatchExecuteStatementRequest): IO[
            AwsError,
            zio.aws.rdsdata.model.BatchExecuteStatementResponse.ReadOnly
          ] = proxy(BatchExecuteStatement, request)
          def executeStatement(
              request: ExecuteStatementRequest
          ): IO[AwsError, ReadOnly] = proxy(ExecuteStatement, request)
          def beginTransaction(request: BeginTransactionRequest): IO[
            AwsError,
            zio.aws.rdsdata.model.BeginTransactionResponse.ReadOnly
          ] = proxy(BeginTransaction, request)
        }
      }
    }
    .toLayer
}
