package zio.aws.rdsdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResultSetOptions(
    decimalReturnType: Option[zio.aws.rdsdata.model.DecimalReturnType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.ResultSetOptions = {
    import ResultSetOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
      .builder()
      .optionallyWith(decimalReturnType.map(value => value.unwrap))(
        _.decimalReturnType
      )
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.ResultSetOptions.ReadOnly =
    zio.aws.rdsdata.model.ResultSetOptions.wrap(buildAwsValue())
}
object ResultSetOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.ResultSetOptions =
      zio.aws.rdsdata.model
        .ResultSetOptions(decimalReturnType.map(value => value))
    def decimalReturnType: Option[zio.aws.rdsdata.model.DecimalReturnType]
    def getDecimalReturnType
        : ZIO[Any, AwsError, zio.aws.rdsdata.model.DecimalReturnType] =
      AwsError.unwrapOptionField("decimalReturnType", decimalReturnType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
  ) extends zio.aws.rdsdata.model.ResultSetOptions.ReadOnly {
    override val decimalReturnType
        : Option[zio.aws.rdsdata.model.DecimalReturnType] = scala
      .Option(impl.decimalReturnType())
      .map(value => zio.aws.rdsdata.model.DecimalReturnType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.ResultSetOptions
  ): zio.aws.rdsdata.model.ResultSetOptions.ReadOnly = new Wrapper(impl)
}
