package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  DBClusterIdentifier,
  GlobalClusterIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SwitchoverGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    targetDbClusterIdentifier: DBClusterIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest = {
    import SwitchoverGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .targetDbClusterIdentifier(
        DBClusterIdentifier.unwrap(targetDbClusterIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.SwitchoverGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.SwitchoverGlobalClusterRequest.wrap(buildAwsValue())
}
object SwitchoverGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.SwitchoverGlobalClusterRequest =
      zio.aws.rds.model.SwitchoverGlobalClusterRequest(
        globalClusterIdentifier,
        targetDbClusterIdentifier
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def targetDbClusterIdentifier: DBClusterIdentifier
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getTargetDbClusterIdentifier: ZIO[Any, Nothing, DBClusterIdentifier] =
      ZIO.succeed(targetDbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest
  ) extends zio.aws.rds.model.SwitchoverGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.rds.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val targetDbClusterIdentifier: DBClusterIdentifier =
      zio.aws.rds.model.primitives
        .DBClusterIdentifier(impl.targetDbClusterIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest
  ): zio.aws.rds.model.SwitchoverGlobalClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
