package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RestoreDbInstanceToPointInTimeResponse(
    dbInstance: Optional[zio.aws.rds.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse = {
    import RestoreDbInstanceToPointInTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly =
    zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse
      .wrap(buildAwsValue())
}
object RestoreDbInstanceToPointInTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse =
      zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse(
        dbInstance.map(value => value.asEditable)
      )
    def dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse
  ) extends zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly {
    override val dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse
  ): zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly =
    new Wrapper(impl)
}
