package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveRoleFromDbInstanceRequest(
    dbInstanceIdentifier: String,
    roleArn: String,
    featureName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest = {
    import RemoveRoleFromDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .roleArn(roleArn: java.lang.String)
      .featureName(featureName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RemoveRoleFromDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.RemoveRoleFromDbInstanceRequest.wrap(buildAwsValue())
}
object RemoveRoleFromDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RemoveRoleFromDbInstanceRequest =
      zio.aws.rds.model.RemoveRoleFromDbInstanceRequest(
        dbInstanceIdentifier,
        roleArn,
        featureName
      )
    def dbInstanceIdentifier: String
    def roleArn: String
    def featureName: String
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getFeatureName: ZIO[Any, Nothing, String] = ZIO.succeed(featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest
  ) extends zio.aws.rds.model.RemoveRoleFromDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val roleArn: String = impl.roleArn(): String
    override val featureName: String = impl.featureName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest
  ): zio.aws.rds.model.RemoveRoleFromDbInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
