package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RdsCustomClusterConfiguration(
    interconnectSubnetId: Optional[String] = Optional.Absent,
    transitGatewayMulticastDomainId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RdsCustomClusterConfiguration = {
    import RdsCustomClusterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RdsCustomClusterConfiguration
      .builder()
      .optionallyWith(
        interconnectSubnetId.map(value => value: java.lang.String)
      )(_.interconnectSubnetId)
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainId)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RdsCustomClusterConfiguration.ReadOnly =
    zio.aws.rds.model.RdsCustomClusterConfiguration.wrap(buildAwsValue())
}
object RdsCustomClusterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RdsCustomClusterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RdsCustomClusterConfiguration =
      zio.aws.rds.model.RdsCustomClusterConfiguration(
        interconnectSubnetId.map(value => value),
        transitGatewayMulticastDomainId.map(value => value)
      )
    def interconnectSubnetId: Optional[String]
    def transitGatewayMulticastDomainId: Optional[String]
    def getInterconnectSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("interconnectSubnetId", interconnectSubnetId)
    def getTransitGatewayMulticastDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RdsCustomClusterConfiguration
  ) extends zio.aws.rds.model.RdsCustomClusterConfiguration.ReadOnly {
    override val interconnectSubnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.interconnectSubnetId())
      .map(value => value: String)
    override val transitGatewayMulticastDomainId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayMulticastDomainId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RdsCustomClusterConfiguration
  ): zio.aws.rds.model.RdsCustomClusterConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
