package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{TStamp, BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PendingModifiedValues(
    dbInstanceClass: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    pendingCloudwatchLogsExports: Optional[
      zio.aws.rds.model.PendingCloudwatchLogsExports
    ] = Optional.Absent,
    processorFeatures: Optional[Iterable[zio.aws.rds.model.ProcessorFeature]] =
      Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      Optional.Absent,
    automationMode: Optional[zio.aws.rds.model.AutomationMode] =
      Optional.Absent,
    resumeFullAutomationModeTime: Optional[TStamp] = Optional.Absent,
    storageThroughput: Optional[IntegerOptional] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    dedicatedLogVolume: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PendingModifiedValues
      .builder()
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        pendingCloudwatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(automationMode.map(value => value.unwrap))(
        _.automationMode
      )
      .optionallyWith(
        resumeFullAutomationModeTime.map(value => TStamp.unwrap(value): Instant)
      )(_.resumeFullAutomationModeTime)
      .optionallyWith(storageThroughput.map(value => value: Integer))(
        _.storageThroughput
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(
        dedicatedLogVolume.map(value => value: java.lang.Boolean)
      )(_.dedicatedLogVolume)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PendingModifiedValues.ReadOnly =
    zio.aws.rds.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PendingModifiedValues =
      zio.aws.rds.model.PendingModifiedValues(
        dbInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        masterUserPassword.map(value => value),
        port.map(value => value),
        backupRetentionPeriod.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        dbInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        caCertificateIdentifier.map(value => value),
        dbSubnetGroupName.map(value => value),
        pendingCloudwatchLogsExports.map(value => value.asEditable),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iamDatabaseAuthenticationEnabled.map(value => value),
        automationMode.map(value => value),
        resumeFullAutomationModeTime.map(value => value),
        storageThroughput.map(value => value),
        engine.map(value => value),
        dedicatedLogVolume.map(value => value)
      )
    def dbInstanceClass: Optional[String]
    def allocatedStorage: Optional[IntegerOptional]
    def masterUserPassword: Optional[String]
    def port: Optional[IntegerOptional]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def multiAZ: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def licenseModel: Optional[String]
    def iops: Optional[IntegerOptional]
    def dbInstanceIdentifier: Optional[String]
    def storageType: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def dbSubnetGroupName: Optional[String]
    def pendingCloudwatchLogsExports
        : Optional[zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly]
    def processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def iamDatabaseAuthenticationEnabled: Optional[BooleanOptional]
    def automationMode: Optional[zio.aws.rds.model.AutomationMode]
    def resumeFullAutomationModeTime: Optional[TStamp]
    def storageThroughput: Optional[IntegerOptional]
    def engine: Optional[String]
    def dedicatedLogVolume: Optional[BooleanOptional]
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPendingCloudwatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudwatchLogsExports",
      pendingCloudwatchLogsExports
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getIamDatabaseAuthenticationEnabled
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "iamDatabaseAuthenticationEnabled",
      iamDatabaseAuthenticationEnabled
    )
    def getAutomationMode
        : ZIO[Any, AwsError, zio.aws.rds.model.AutomationMode] =
      AwsError.unwrapOptionField("automationMode", automationMode)
    def getResumeFullAutomationModeTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "resumeFullAutomationModeTime",
        resumeFullAutomationModeTime
      )
    def getStorageThroughput: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageThroughput", storageThroughput)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getDedicatedLogVolume: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("dedicatedLogVolume", dedicatedLogVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PendingModifiedValues
  ) extends zio.aws.rds.model.PendingModifiedValues.ReadOnly {
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val pendingCloudwatchLogsExports
        : Optional[zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingCloudwatchLogsExports())
        .map(value =>
          zio.aws.rds.model.PendingCloudwatchLogsExports.wrap(value)
        )
    override val processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: BooleanOptional)
    override val automationMode: Optional[zio.aws.rds.model.AutomationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automationMode())
        .map(value => zio.aws.rds.model.AutomationMode.wrap(value))
    override val resumeFullAutomationModeTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resumeFullAutomationModeTime())
        .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val storageThroughput: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughput())
        .map(value => value: IntegerOptional)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val dedicatedLogVolume: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedLogVolume())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PendingModifiedValues
  ): zio.aws.rds.model.PendingModifiedValues.ReadOnly = new Wrapper(impl)
}
