package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait IntegrationStatus {
  def unwrap: software.amazon.awssdk.services.rds.model.IntegrationStatus
}
object IntegrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.IntegrationStatus
  ): zio.aws.rds.model.IntegrationStatus = value match {
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.SYNCING =>
      val r = syncing
      r
    case software.amazon.awssdk.services.rds.model.IntegrationStatus.NEEDS_ATTENTION =>
      val r = needs_attention
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object creating extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.CREATING
  }
  case object active extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.ACTIVE
  }
  case object modifying extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.MODIFYING
  }
  case object failed extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.FAILED
  }
  case object deleting extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.DELETING
  }
  case object syncing extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.SYNCING
  }
  case object needs_attention extends zio.aws.rds.model.IntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.IntegrationStatus =
      software.amazon.awssdk.services.rds.model.IntegrationStatus.NEEDS_ATTENTION
  }
}
