package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  IntegrationName,
  SourceArn,
  Arn,
  TStamp,
  IntegrationArn
}
import scala.jdk.CollectionConverters.*
final case class Integration(
    sourceArn: Optional[SourceArn] = Optional.Absent,
    targetArn: Optional[Arn] = Optional.Absent,
    integrationName: Optional[IntegrationName] = Optional.Absent,
    integrationArn: Optional[IntegrationArn] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    additionalEncryptionContext: Optional[Map[String, String]] =
      Optional.Absent,
    status: Optional[zio.aws.rds.model.IntegrationStatus] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    createTime: Optional[TStamp] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.rds.model.IntegrationError]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Integration = {
    import Integration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Integration
      .builder()
      .optionallyWith(
        sourceArn.map(value => SourceArn.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(
        targetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        integrationName.map(value =>
          IntegrationName.unwrap(value): java.lang.String
        )
      )(_.integrationName)
      .optionallyWith(
        integrationArn.map(value =>
          IntegrationArn.unwrap(value): java.lang.String
        )
      )(_.integrationArn)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        additionalEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalEncryptionContext)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(createTime.map(value => TStamp.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Integration.ReadOnly =
    zio.aws.rds.model.Integration.wrap(buildAwsValue())
}
object Integration {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Integration] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Integration =
      zio.aws.rds.model.Integration(
        sourceArn.map(value => value),
        targetArn.map(value => value),
        integrationName.map(value => value),
        integrationArn.map(value => value),
        kmsKeyId.map(value => value),
        additionalEncryptionContext.map(value => value),
        status.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createTime.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceArn: Optional[SourceArn]
    def targetArn: Optional[Arn]
    def integrationName: Optional[IntegrationName]
    def integrationArn: Optional[IntegrationArn]
    def kmsKeyId: Optional[String]
    def additionalEncryptionContext: Optional[Map[String, String]]
    def status: Optional[zio.aws.rds.model.IntegrationStatus]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def createTime: Optional[TStamp]
    def errors: Optional[List[zio.aws.rds.model.IntegrationError.ReadOnly]]
    def getSourceArn: ZIO[Any, AwsError, SourceArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getTargetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getIntegrationName: ZIO[Any, AwsError, IntegrationName] =
      AwsError.unwrapOptionField("integrationName", integrationName)
    def getIntegrationArn: ZIO[Any, AwsError, IntegrationArn] =
      AwsError.unwrapOptionField("integrationArn", integrationArn)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAdditionalEncryptionContext
        : ZIO[Any, AwsError, Map[String, String]] = AwsError.unwrapOptionField(
      "additionalEncryptionContext",
      additionalEncryptionContext
    )
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.IntegrationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.rds.model.IntegrationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Integration
  ) extends zio.aws.rds.model.Integration.ReadOnly {
    override val sourceArn: Optional[SourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.rds.model.primitives.SourceArn(value))
    override val targetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.rds.model.primitives.Arn(value))
    override val integrationName: Optional[IntegrationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationName())
        .map(value => zio.aws.rds.model.primitives.IntegrationName(value))
    override val integrationArn: Optional[IntegrationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationArn())
        .map(value => zio.aws.rds.model.primitives.IntegrationArn(value))
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val additionalEncryptionContext: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalEncryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val status: Optional[zio.aws.rds.model.IntegrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rds.model.IntegrationStatus.wrap(value))
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val createTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val errors
        : Optional[List[zio.aws.rds.model.IntegrationError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.IntegrationError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Integration
  ): zio.aws.rds.model.Integration.ReadOnly = new Wrapper(impl)
}
