package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  BooleanOptional,
  DBClusterIdentifier,
  GlobalClusterIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailoverGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    targetDbClusterIdentifier: DBClusterIdentifier,
    allowDataLoss: Optional[BooleanOptional] = Optional.Absent,
    switchover: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest = {
    import FailoverGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .targetDbClusterIdentifier(
        DBClusterIdentifier.unwrap(targetDbClusterIdentifier): java.lang.String
      )
      .optionallyWith(allowDataLoss.map(value => value: java.lang.Boolean))(
        _.allowDataLoss
      )
      .optionallyWith(switchover.map(value => value: java.lang.Boolean))(
        _.switchover
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.FailoverGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.FailoverGlobalClusterRequest.wrap(buildAwsValue())
}
object FailoverGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.FailoverGlobalClusterRequest =
      zio.aws.rds.model.FailoverGlobalClusterRequest(
        globalClusterIdentifier,
        targetDbClusterIdentifier,
        allowDataLoss.map(value => value),
        switchover.map(value => value)
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def targetDbClusterIdentifier: DBClusterIdentifier
    def allowDataLoss: Optional[BooleanOptional]
    def switchover: Optional[BooleanOptional]
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getTargetDbClusterIdentifier: ZIO[Any, Nothing, DBClusterIdentifier] =
      ZIO.succeed(targetDbClusterIdentifier)
    def getAllowDataLoss: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowDataLoss", allowDataLoss)
    def getSwitchover: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("switchover", switchover)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
  ) extends zio.aws.rds.model.FailoverGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.rds.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val targetDbClusterIdentifier: DBClusterIdentifier =
      zio.aws.rds.model.primitives
        .DBClusterIdentifier(impl.targetDbClusterIdentifier())
    override val allowDataLoss: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowDataLoss())
        .map(value => value: BooleanOptional)
    override val switchover: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.switchover())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
  ): zio.aws.rds.model.FailoverGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
