package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainMembership(
    domain: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    fqdn: Optional[String] = Optional.Absent,
    iamRoleName: Optional[String] = Optional.Absent,
    ou: Optional[String] = Optional.Absent,
    authSecretArn: Optional[String] = Optional.Absent,
    dnsIps: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DomainMembership = {
    import DomainMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DomainMembership
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(fqdn.map(value => value: java.lang.String))(_.fqdn)
      .optionallyWith(iamRoleName.map(value => value: java.lang.String))(
        _.iamRoleName
      )
      .optionallyWith(ou.map(value => value: java.lang.String))(_.ou)
      .optionallyWith(authSecretArn.map(value => value: java.lang.String))(
        _.authSecretArn
      )
      .optionallyWith(
        dnsIps.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIps)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DomainMembership.ReadOnly =
    zio.aws.rds.model.DomainMembership.wrap(buildAwsValue())
}
object DomainMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DomainMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DomainMembership =
      zio.aws.rds.model.DomainMembership(
        domain.map(value => value),
        status.map(value => value),
        fqdn.map(value => value),
        iamRoleName.map(value => value),
        ou.map(value => value),
        authSecretArn.map(value => value),
        dnsIps.map(value => value)
      )
    def domain: Optional[String]
    def status: Optional[String]
    def fqdn: Optional[String]
    def iamRoleName: Optional[String]
    def ou: Optional[String]
    def authSecretArn: Optional[String]
    def dnsIps: Optional[List[String]]
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFqdn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fqdn", fqdn)
    def getIamRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRoleName", iamRoleName)
    def getOu: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("ou", ou)
    def getAuthSecretArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authSecretArn", authSecretArn)
    def getDnsIps: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsIps", dnsIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DomainMembership
  ) extends zio.aws.rds.model.DomainMembership.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val fqdn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fqdn())
      .map(value => value: String)
    override val iamRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleName())
      .map(value => value: String)
    override val ou: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ou())
      .map(value => value: String)
    override val authSecretArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authSecretArn())
      .map(value => value: String)
    override val dnsIps: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsIps())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DomainMembership
  ): zio.aws.rds.model.DomainMembership.ReadOnly = new Wrapper(impl)
}
