package zio.aws.rds.model
import zio.aws.rds.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeIntegrationsResponse(
    marker: Optional[Marker] = Optional.Absent,
    integrations: Optional[Iterable[zio.aws.rds.model.Integration]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse = {
    import DescribeIntegrationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        integrations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integrations)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeIntegrationsResponse.ReadOnly =
    zio.aws.rds.model.DescribeIntegrationsResponse.wrap(buildAwsValue())
}
object DescribeIntegrationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeIntegrationsResponse =
      zio.aws.rds.model.DescribeIntegrationsResponse(
        marker.map(value => value),
        integrations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[Marker]
    def integrations: Optional[List[zio.aws.rds.model.Integration.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getIntegrations
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Integration.ReadOnly]] =
      AwsError.unwrapOptionField("integrations", integrations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse
  ) extends zio.aws.rds.model.DescribeIntegrationsResponse.ReadOnly {
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.rds.model.primitives.Marker(value))
    override val integrations
        : Optional[List[zio.aws.rds.model.Integration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Integration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse
  ): zio.aws.rds.model.DescribeIntegrationsResponse.ReadOnly = new Wrapper(impl)
}
