package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  Marker,
  IntegerOptional,
  IntegrationIdentifier
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeIntegrationsRequest(
    integrationIdentifier: Optional[IntegrationIdentifier] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest = {
    import DescribeIntegrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest
      .builder()
      .optionallyWith(
        integrationIdentifier.map(value =>
          IntegrationIdentifier.unwrap(value): java.lang.String
        )
      )(_.integrationIdentifier)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeIntegrationsRequest.ReadOnly =
    zio.aws.rds.model.DescribeIntegrationsRequest.wrap(buildAwsValue())
}
object DescribeIntegrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeIntegrationsRequest =
      zio.aws.rds.model.DescribeIntegrationsRequest(
        integrationIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def integrationIdentifier: Optional[IntegrationIdentifier]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[Marker]
    def getIntegrationIdentifier: ZIO[Any, AwsError, IntegrationIdentifier] =
      AwsError.unwrapOptionField("integrationIdentifier", integrationIdentifier)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest
  ) extends zio.aws.rds.model.DescribeIntegrationsRequest.ReadOnly {
    override val integrationIdentifier: Optional[IntegrationIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationIdentifier())
        .map(value => zio.aws.rds.model.primitives.IntegrationIdentifier(value))
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.rds.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest
  ): zio.aws.rds.model.DescribeIntegrationsRequest.ReadOnly = new Wrapper(impl)
}
