package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDbClusterBacktracksResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusterBacktracks: Optional[
      Iterable[zio.aws.rds.model.DBClusterBacktrack]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse = {
    import DescribeDbClusterBacktracksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterBacktracks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterBacktracks)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterBacktracksResponse.wrap(buildAwsValue())
}
object DescribeDbClusterBacktracksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterBacktracksResponse =
      zio.aws.rds.model.DescribeDbClusterBacktracksResponse(
        marker.map(value => value),
        dbClusterBacktracks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusterBacktracks
        : Optional[List[zio.aws.rds.model.DBClusterBacktrack.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterBacktracks: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterBacktrack.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterBacktracks", dbClusterBacktracks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse
  ) extends zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusterBacktracks
        : Optional[List[zio.aws.rds.model.DBClusterBacktrack.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterBacktracks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBClusterBacktrack.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse
  ): zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly =
    new Wrapper(impl)
}
