package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDbClusterAutomatedBackupsResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusterAutomatedBackups: Optional[
      Iterable[zio.aws.rds.model.DBClusterAutomatedBackup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse = {
    import DescribeDbClusterAutomatedBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterAutomatedBackups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterAutomatedBackups)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterAutomatedBackupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterAutomatedBackupsResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterAutomatedBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeDbClusterAutomatedBackupsResponse =
      zio.aws.rds.model.DescribeDbClusterAutomatedBackupsResponse(
        marker.map(value => value),
        dbClusterAutomatedBackups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusterAutomatedBackups
        : Optional[List[zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterAutomatedBackups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterAutomatedBackups",
      dbClusterAutomatedBackups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse
  ) extends zio.aws.rds.model.DescribeDbClusterAutomatedBackupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusterAutomatedBackups
        : Optional[List[zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterAutomatedBackups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBClusterAutomatedBackup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse
  ): zio.aws.rds.model.DescribeDbClusterAutomatedBackupsResponse.ReadOnly =
    new Wrapper(impl)
}
