package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeBlueGreenDeploymentsResponse(
    blueGreenDeployments: Optional[
      Iterable[zio.aws.rds.model.BlueGreenDeployment]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse = {
    import DescribeBlueGreenDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse
      .builder()
      .optionallyWith(
        blueGreenDeployments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blueGreenDeployments)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.ReadOnly =
    zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.wrap(buildAwsValue())
}
object DescribeBlueGreenDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse =
      zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse(
        blueGreenDeployments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def blueGreenDeployments
        : Optional[List[zio.aws.rds.model.BlueGreenDeployment.ReadOnly]]
    def marker: Optional[String]
    def getBlueGreenDeployments: ZIO[Any, AwsError, List[
      zio.aws.rds.model.BlueGreenDeployment.ReadOnly
    ]] =
      AwsError.unwrapOptionField("blueGreenDeployments", blueGreenDeployments)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse
  ) extends zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.ReadOnly {
    override val blueGreenDeployments
        : Optional[List[zio.aws.rds.model.BlueGreenDeployment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueGreenDeployments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.BlueGreenDeployment.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse
  ): zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.ReadOnly =
    new Wrapper(impl)
}
