package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{MaxRecords, BlueGreenDeploymentIdentifier}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeBlueGreenDeploymentsRequest(
    blueGreenDeploymentIdentifier: Optional[BlueGreenDeploymentIdentifier] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[MaxRecords] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest = {
    import DescribeBlueGreenDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest
      .builder()
      .optionallyWith(
        blueGreenDeploymentIdentifier.map(value =>
          BlueGreenDeploymentIdentifier.unwrap(value): java.lang.String
        )
      )(_.blueGreenDeploymentIdentifier)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest.ReadOnly =
    zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest.wrap(buildAwsValue())
}
object DescribeBlueGreenDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest =
      zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest(
        blueGreenDeploymentIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def blueGreenDeploymentIdentifier: Optional[BlueGreenDeploymentIdentifier]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def marker: Optional[String]
    def maxRecords: Optional[MaxRecords]
    def getBlueGreenDeploymentIdentifier
        : ZIO[Any, AwsError, BlueGreenDeploymentIdentifier] =
      AwsError.unwrapOptionField(
        "blueGreenDeploymentIdentifier",
        blueGreenDeploymentIdentifier
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest
  ) extends zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest.ReadOnly {
    override val blueGreenDeploymentIdentifier
        : Optional[BlueGreenDeploymentIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.blueGreenDeploymentIdentifier())
      .map(value =>
        zio.aws.rds.model.primitives.BlueGreenDeploymentIdentifier(value)
      )
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[MaxRecords] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.MaxRecords(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest
  ): zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest.ReadOnly =
    new Wrapper(impl)
}
