package zio.aws.rds.model
import zio.aws.rds.model.primitives.IntegrationIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteIntegrationRequest(
    integrationIdentifier: IntegrationIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest = {
    import DeleteIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest
      .builder()
      .integrationIdentifier(
        IntegrationIdentifier.unwrap(integrationIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteIntegrationRequest.ReadOnly =
    zio.aws.rds.model.DeleteIntegrationRequest.wrap(buildAwsValue())
}
object DeleteIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteIntegrationRequest =
      zio.aws.rds.model.DeleteIntegrationRequest(integrationIdentifier)
    def integrationIdentifier: IntegrationIdentifier
    def getIntegrationIdentifier: ZIO[Any, Nothing, IntegrationIdentifier] =
      ZIO.succeed(integrationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest
  ) extends zio.aws.rds.model.DeleteIntegrationRequest.ReadOnly {
    override val integrationIdentifier: IntegrationIdentifier =
      zio.aws.rds.model.primitives
        .IntegrationIdentifier(impl.integrationIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest
  ): zio.aws.rds.model.DeleteIntegrationRequest.ReadOnly = new Wrapper(impl)
}
