package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDbClusterAutomatedBackupResponse(
    dbClusterAutomatedBackup: Optional[
      zio.aws.rds.model.DBClusterAutomatedBackup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse = {
    import DeleteDbClusterAutomatedBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse
      .builder()
      .optionallyWith(
        dbClusterAutomatedBackup.map(value => value.buildAwsValue())
      )(_.dbClusterAutomatedBackup)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DeleteDbClusterAutomatedBackupResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbClusterAutomatedBackupResponse
      .wrap(buildAwsValue())
}
object DeleteDbClusterAutomatedBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbClusterAutomatedBackupResponse =
      zio.aws.rds.model.DeleteDbClusterAutomatedBackupResponse(
        dbClusterAutomatedBackup.map(value => value.asEditable)
      )
    def dbClusterAutomatedBackup
        : Optional[zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly]
    def getDbClusterAutomatedBackup: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterAutomatedBackup",
      dbClusterAutomatedBackup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse
  ) extends zio.aws.rds.model.DeleteDbClusterAutomatedBackupResponse.ReadOnly {
    override val dbClusterAutomatedBackup
        : Optional[zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterAutomatedBackup())
        .map(value => zio.aws.rds.model.DBClusterAutomatedBackup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse
  ): zio.aws.rds.model.DeleteDbClusterAutomatedBackupResponse.ReadOnly =
    new Wrapper(impl)
}
