package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDbClusterAutomatedBackupRequest(
    dbClusterResourceId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest = {
    import DeleteDbClusterAutomatedBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest
      .builder()
      .dbClusterResourceId(dbClusterResourceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DeleteDbClusterAutomatedBackupRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbClusterAutomatedBackupRequest
      .wrap(buildAwsValue())
}
object DeleteDbClusterAutomatedBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbClusterAutomatedBackupRequest =
      zio.aws.rds.model
        .DeleteDbClusterAutomatedBackupRequest(dbClusterResourceId)
    def dbClusterResourceId: String
    def getDbClusterResourceId: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest
  ) extends zio.aws.rds.model.DeleteDbClusterAutomatedBackupRequest.ReadOnly {
    override val dbClusterResourceId: String =
      impl.dbClusterResourceId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest
  ): zio.aws.rds.model.DeleteDbClusterAutomatedBackupRequest.ReadOnly =
    new Wrapper(impl)
}
