package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  BooleanOptional,
  BlueGreenDeploymentIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteBlueGreenDeploymentRequest(
    blueGreenDeploymentIdentifier: BlueGreenDeploymentIdentifier,
    deleteTarget: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest = {
    import DeleteBlueGreenDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest
      .builder()
      .blueGreenDeploymentIdentifier(
        BlueGreenDeploymentIdentifier.unwrap(
          blueGreenDeploymentIdentifier
        ): java.lang.String
      )
      .optionallyWith(deleteTarget.map(value => value: java.lang.Boolean))(
        _.deleteTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteBlueGreenDeploymentRequest.ReadOnly =
    zio.aws.rds.model.DeleteBlueGreenDeploymentRequest.wrap(buildAwsValue())
}
object DeleteBlueGreenDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteBlueGreenDeploymentRequest =
      zio.aws.rds.model.DeleteBlueGreenDeploymentRequest(
        blueGreenDeploymentIdentifier,
        deleteTarget.map(value => value)
      )
    def blueGreenDeploymentIdentifier: BlueGreenDeploymentIdentifier
    def deleteTarget: Optional[BooleanOptional]
    def getBlueGreenDeploymentIdentifier
        : ZIO[Any, Nothing, BlueGreenDeploymentIdentifier] =
      ZIO.succeed(blueGreenDeploymentIdentifier)
    def getDeleteTarget: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deleteTarget", deleteTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest
  ) extends zio.aws.rds.model.DeleteBlueGreenDeploymentRequest.ReadOnly {
    override val blueGreenDeploymentIdentifier: BlueGreenDeploymentIdentifier =
      zio.aws.rds.model.primitives
        .BlueGreenDeploymentIdentifier(impl.blueGreenDeploymentIdentifier())
    override val deleteTarget: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteTarget())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest
  ): zio.aws.rds.model.DeleteBlueGreenDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
