package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{IntegerOptional, Integer, TStamp}
import scala.jdk.CollectionConverters.*
final case class DBSnapshot(
    dbSnapshotIdentifier: Optional[String] = Optional.Absent,
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    snapshotCreateTime: Optional[TStamp] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    instanceCreateTime: Optional[TStamp] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    snapshotType: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    percentProgress: Optional[Integer] = Optional.Absent,
    sourceRegion: Optional[String] = Optional.Absent,
    sourceDBSnapshotIdentifier: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    tdeCredentialArn: Optional[String] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    dbSnapshotArn: Optional[String] = Optional.Absent,
    timezone: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    processorFeatures: Optional[Iterable[zio.aws.rds.model.ProcessorFeature]] =
      Optional.Absent,
    dbiResourceId: Optional[String] = Optional.Absent,
    tagList: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    originalSnapshotCreateTime: Optional[TStamp] = Optional.Absent,
    snapshotDatabaseTime: Optional[TStamp] = Optional.Absent,
    snapshotTarget: Optional[String] = Optional.Absent,
    storageThroughput: Optional[IntegerOptional] = Optional.Absent,
    dbSystemId: Optional[String] = Optional.Absent,
    dedicatedLogVolume: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSnapshot = {
    import DBSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSnapshot
      .builder()
      .optionallyWith(
        dbSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbSnapshotIdentifier)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(sourceRegion.map(value => value: java.lang.String))(
        _.sourceRegion
      )
      .optionallyWith(
        sourceDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.sourceDBSnapshotIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(dbSnapshotArn.map(value => value: java.lang.String))(
        _.dbSnapshotArn
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        originalSnapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.originalSnapshotCreateTime)
      .optionallyWith(
        snapshotDatabaseTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotDatabaseTime)
      .optionallyWith(snapshotTarget.map(value => value: java.lang.String))(
        _.snapshotTarget
      )
      .optionallyWith(storageThroughput.map(value => value: java.lang.Integer))(
        _.storageThroughput
      )
      .optionallyWith(dbSystemId.map(value => value: java.lang.String))(
        _.dbSystemId
      )
      .optionallyWith(
        dedicatedLogVolume.map(value => value: java.lang.Boolean)
      )(_.dedicatedLogVolume)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSnapshot.ReadOnly =
    zio.aws.rds.model.DBSnapshot.wrap(buildAwsValue())
}
object DBSnapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBSnapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSnapshot = zio.aws.rds.model.DBSnapshot(
      dbSnapshotIdentifier.map(value => value),
      dbInstanceIdentifier.map(value => value),
      snapshotCreateTime.map(value => value),
      engine.map(value => value),
      allocatedStorage.map(value => value),
      status.map(value => value),
      port.map(value => value),
      availabilityZone.map(value => value),
      vpcId.map(value => value),
      instanceCreateTime.map(value => value),
      masterUsername.map(value => value),
      engineVersion.map(value => value),
      licenseModel.map(value => value),
      snapshotType.map(value => value),
      iops.map(value => value),
      optionGroupName.map(value => value),
      percentProgress.map(value => value),
      sourceRegion.map(value => value),
      sourceDBSnapshotIdentifier.map(value => value),
      storageType.map(value => value),
      tdeCredentialArn.map(value => value),
      encrypted.map(value => value),
      kmsKeyId.map(value => value),
      dbSnapshotArn.map(value => value),
      timezone.map(value => value),
      iamDatabaseAuthenticationEnabled.map(value => value),
      processorFeatures.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbiResourceId.map(value => value),
      tagList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      originalSnapshotCreateTime.map(value => value),
      snapshotDatabaseTime.map(value => value),
      snapshotTarget.map(value => value),
      storageThroughput.map(value => value),
      dbSystemId.map(value => value),
      dedicatedLogVolume.map(value => value)
    )
    def dbSnapshotIdentifier: Optional[String]
    def dbInstanceIdentifier: Optional[String]
    def snapshotCreateTime: Optional[TStamp]
    def engine: Optional[String]
    def allocatedStorage: Optional[Integer]
    def status: Optional[String]
    def port: Optional[Integer]
    def availabilityZone: Optional[String]
    def vpcId: Optional[String]
    def instanceCreateTime: Optional[TStamp]
    def masterUsername: Optional[String]
    def engineVersion: Optional[String]
    def licenseModel: Optional[String]
    def snapshotType: Optional[String]
    def iops: Optional[IntegerOptional]
    def optionGroupName: Optional[String]
    def percentProgress: Optional[Integer]
    def sourceRegion: Optional[String]
    def sourceDBSnapshotIdentifier: Optional[String]
    def storageType: Optional[String]
    def tdeCredentialArn: Optional[String]
    def encrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def dbSnapshotArn: Optional[String]
    def timezone: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def dbiResourceId: Optional[String]
    def tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def originalSnapshotCreateTime: Optional[TStamp]
    def snapshotDatabaseTime: Optional[TStamp]
    def snapshotTarget: Optional[String]
    def storageThroughput: Optional[IntegerOptional]
    def dbSystemId: Optional[String]
    def dedicatedLogVolume: Optional[Boolean]
    def getDbSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifier)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getSourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getSourceDBSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBSnapshotIdentifier",
        sourceDBSnapshotIdentifier
      )
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSnapshotArn", dbSnapshotArn)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getOriginalSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "originalSnapshotCreateTime",
        originalSnapshotCreateTime
      )
    def getSnapshotDatabaseTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotDatabaseTime", snapshotDatabaseTime)
    def getSnapshotTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotTarget", snapshotTarget)
    def getStorageThroughput: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageThroughput", storageThroughput)
    def getDbSystemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSystemId", dbSystemId)
    def getDedicatedLogVolume: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dedicatedLogVolume", dedicatedLogVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshot
  ) extends zio.aws.rds.model.DBSnapshot.ReadOnly {
    override val dbSnapshotIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSnapshotIdentifier())
      .map(value => value: String)
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val snapshotCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val instanceCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val snapshotType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotType())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val percentProgress: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentProgress())
      .map(value => value: Integer)
    override val sourceRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRegion())
      .map(value => value: String)
    override val sourceDBSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDBSnapshotIdentifier())
        .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val tdeCredentialArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialArn())
      .map(value => value: String)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val dbSnapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSnapshotArn())
      .map(value => value: String)
    override val timezone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val dbiResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => value: String)
    override val tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val originalSnapshotCreateTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originalSnapshotCreateTime())
        .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val snapshotDatabaseTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotDatabaseTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val snapshotTarget: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotTarget())
      .map(value => value: String)
    override val storageThroughput: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughput())
        .map(value => value: IntegerOptional)
    override val dbSystemId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSystemId())
      .map(value => value: String)
    override val dedicatedLogVolume: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dedicatedLogVolume())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshot
  ): zio.aws.rds.model.DBSnapshot.ReadOnly = new Wrapper(impl)
}
