package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{IntegerOptional, Integer, TStamp}
import scala.jdk.CollectionConverters.*
final case class DBClusterAutomatedBackup(
    engine: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    dbClusterAutomatedBackupsArn: Optional[String] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    restoreWindow: Optional[zio.aws.rds.model.RestoreWindow] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    dbClusterResourceId: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    clusterCreateTime: Optional[TStamp] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    dbClusterArn: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    engineMode: Optional[String] = Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    awsBackupRecoveryPointArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup = {
    import DBClusterAutomatedBackup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        dbClusterAutomatedBackupsArn.map(value => value: java.lang.String)
      )(_.dbClusterAutomatedBackupsArn)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(restoreWindow.map(value => value.buildAwsValue()))(
        _.restoreWindow
      )
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(
        dbClusterResourceId.map(value => value: java.lang.String)
      )(_.dbClusterResourceId)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        awsBackupRecoveryPointArn.map(value => value: java.lang.String)
      )(_.awsBackupRecoveryPointArn)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly =
    zio.aws.rds.model.DBClusterAutomatedBackup.wrap(buildAwsValue())
}
object DBClusterAutomatedBackup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterAutomatedBackup =
      zio.aws.rds.model.DBClusterAutomatedBackup(
        engine.map(value => value),
        vpcId.map(value => value),
        dbClusterAutomatedBackupsArn.map(value => value),
        dbClusterIdentifier.map(value => value),
        restoreWindow.map(value => value.asEditable),
        masterUsername.map(value => value),
        dbClusterResourceId.map(value => value),
        region.map(value => value),
        licenseModel.map(value => value),
        status.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        clusterCreateTime.map(value => value),
        storageEncrypted.map(value => value),
        allocatedStorage.map(value => value),
        engineVersion.map(value => value),
        dbClusterArn.map(value => value),
        backupRetentionPeriod.map(value => value),
        engineMode.map(value => value),
        availabilityZones.map(value => value),
        port.map(value => value),
        kmsKeyId.map(value => value),
        storageType.map(value => value),
        iops.map(value => value),
        awsBackupRecoveryPointArn.map(value => value)
      )
    def engine: Optional[String]
    def vpcId: Optional[String]
    def dbClusterAutomatedBackupsArn: Optional[String]
    def dbClusterIdentifier: Optional[String]
    def restoreWindow: Optional[zio.aws.rds.model.RestoreWindow.ReadOnly]
    def masterUsername: Optional[String]
    def dbClusterResourceId: Optional[String]
    def region: Optional[String]
    def licenseModel: Optional[String]
    def status: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def clusterCreateTime: Optional[TStamp]
    def storageEncrypted: Optional[Boolean]
    def allocatedStorage: Optional[Integer]
    def engineVersion: Optional[String]
    def dbClusterArn: Optional[String]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def engineMode: Optional[String]
    def availabilityZones: Optional[List[String]]
    def port: Optional[Integer]
    def kmsKeyId: Optional[String]
    def storageType: Optional[String]
    def iops: Optional[IntegerOptional]
    def awsBackupRecoveryPointArn: Optional[String]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getDbClusterAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterAutomatedBackupsArn",
        dbClusterAutomatedBackupsArn
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getRestoreWindow
        : ZIO[Any, AwsError, zio.aws.rds.model.RestoreWindow.ReadOnly] =
      AwsError.unwrapOptionField("restoreWindow", restoreWindow)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbClusterResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceId)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getAwsBackupRecoveryPointArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("awsBackupRecoveryPointArn", awsBackupRecoveryPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup
  ) extends zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val dbClusterAutomatedBackupsArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterAutomatedBackupsArn())
        .map(value => value: String)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val restoreWindow
        : Optional[zio.aws.rds.model.RestoreWindow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreWindow())
        .map(value => zio.aws.rds.model.RestoreWindow.wrap(value))
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val dbClusterResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterResourceId())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val clusterCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterArn())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val engineMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineMode())
      .map(value => value: String)
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val awsBackupRecoveryPointArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsBackupRecoveryPointArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup
  ): zio.aws.rds.model.DBClusterAutomatedBackup.ReadOnly = new Wrapper(impl)
}
